/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// Anonymous function
//
(function( window, undefined )
{
	// initialize
	var app = new h5glib.Application();

	var scene	= new h5glib.IconRaceScene( app, "irace" );
	app.sceneManager.add( scene );
	app.sceneManager.push( scene.name );

	// window.onload のタイミング
	app.addSysEventHandler( window, "load", function()
	{
		app.init();
	});

	// Expose
	if ( !window.h5glib ) { window.h5glib = {}; }
	// for debug
	if ( h5glib.Config.debug )
	{
		window.h5glib.app = app;
	}
	// JSONP callback func
	window.h5glib.loadDataCB = function( json )
	{
		app.sceneManager.current.loadData( json );
	};

})( window );
