<?php
/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

define( "DEBUG", false );

/**
 * 
 */
class StageWriter
{
	const APP_HOME		= "..";
	const FILENAME_DATA	= "stage.js";
	const FUNCNAME_CB	= "window.h5glib.loadDataCB";

	/**
	 * 
	 */
	public function write( $baseUrl, $json )
	{
		$result = "NG: ";

		try
		{
			if ( empty( $baseUrl ) )
			{
				throw new Exception("NG: no parameter. parameter=baseUrl");
			}
			if ( empty( $json ) )
			{
				throw new Exception("NG: no parameter. parameter=json");
			}

			$filePath	= $this->getDataFilePath( $baseUrl );
			$data		= $this->getJsonpData( $json );

			$result		= $this->writeToFile( $filePath, $data );
		}
		catch ( Exception $e )
		{
			$result = $e->getMessage();
		}
		return $result;
	}

	/**
	 * 
	 */
	private function getDataFilePath( $baseUrl )
	{
		$str	= $baseUrl;

		// for null byte
		$str	= str_replace( pack("x"), "", $str );
		// cut tail slash
		$str	= rtrim( $str, "/" );
		// get base name
		$str	= basename( $str );
		// get file path
		$filePath	= self::APP_HOME . "/" . $str . "/" . self::FILENAME_DATA;
		// check existense
		if ( is_file( $filePath ) === false )
		{
			throw new Exception("NG: data file not found. fileName=$filePath");
		}
		return $filePath;
	}

	/**
	 * 
	 */
	private function getJsonpData( $json )
	{
		$str	= $json;

		// for null byte
		$str	= str_replace( pack("x"), "", $str );
		// for magic_quotes_gpc
		$str	= stripcslashes( $str );
		// for javascript injection
		$str	= str_replace( ";", "；", $str );

		return self::FUNCNAME_CB . "(\n{\n" . $str . "});";
	}

	/**
	 * 
	 */
	private function writeToFile( $filePath, $data )
	{
		$filePathBack	= $filePath . ".back";

		// create backup
		if ( file_exists( $filePathBack ) )
		{
			if ( @unlink( $filePathBack ) === false )
			{
				throw new Exception("NG: deleting backup file failed. fileName=$filePathBack");
			}
		}
		if ( @rename( $filePath, $filePathBack ) === false )
		{
			throw new Exception("NG: renaming backup file failed. fileName=$filePathBack");
		}
		// write data
		$fp = @fopen( $filePath, "w" );
		if ( $fp === false )
		{
			throw new Exception("NG: opening data file failed. fileName=$filePath");
		}
		if ( @fwrite( $fp, $data ) == false )
		{
			fclose( $fp );
			throw new Exception("NG: writing data file failed. fileName=$filePath");
		}
		fclose( $fp );

		return "OK: succeeded.";
	}
}

/**
 * Entry point
 */
function main()
{
	// create StageWriter
	$writer = new StageWriter();
	$result = $writer->write( $_POST["baseUrl"], $_POST["json"] );

	// write result
	if ( DEBUG )
	{
		print <<< _EOF_
<!DOCTYPE html>
<html lang="ja">
<head>
	<meta charset="UTF-8" />
</head>
<body>
	<p>{$result}</p>
	<form action="stageWriter.php" method="POST">
		baseUrl: <input type="text" name="baseUrl"><br>
		json: <input type="text" name="json"><br>
		<input type="submit" value="submit">
	</form>
</body>
</html>
_EOF_;
	}
	else
	{
		print( $result );
	}
}

// call Entry point
main();

?>
