/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// Anonymous function start
//
(function( window, undefined )
{

// reference
var Config			= window.h5glib.Config;
var Debug			= window.h5glib.Debug;
var Command			= window.h5glib.Command;
var Task			= window.h5glib.Task;
var SoundTask		= window.h5glib.SoundTask;
var ReadyTask		= window.h5glib.ReadyTask;
var ImageAnimator	= window.h5glib.ImageAnimator;
var Message			= window.h5glib.Message;
var MessageHandler	= window.h5glib.MessageHandler;
var MessageManager	= window.h5glib.MessageManager;
var SceneStatus		= window.h5glib.SceneStatus;
var Scene			= window.h5glib.Scene;

/**
 * RenderInfo
 */
var RenderInfo =
{
	chipPixels	: 32
};

/**
 * Res
 */
var Res =
{
	String :
	{
		HTML_USAGE		: "<p>" +
						  "[↑][←][↓][→]: 選択<br>" +
						  "[Z][Enter] OK, [X][Esc] Cancel<br>" +
						  "<br>" +
						  "</p>"
	},
	Color :
	{
		BACKGROUND		: "black",
		RECT			: "rgba(192, 80, 77, 0.7)",
		BORDER			: "rgb(192, 192, 192)",
		FONT			: "rgb(255, 255, 255)",
		FOCUS			: "rgba(100, 149, 237, 0.7)",
	},
	Font :
	{
		LARGE			: "bold 18px 'ＭＳ Ｐゴシック'",
		SMALL			: "bold 14px 'ＭＳ Ｐゴシック'"
	}
};

/**
 * MessageType
 */
var MessageType =
{
	NONE			: 0,
	RET_PREV_SCENE	: 1
};

/**
 * EventType
 */
var EventType =
{
	NONE	: "none"
};

/**
 * ShopTask
 */
var ShopTask = function( scene )
{
	this.command	= scene.command;	// input
	this.select		= 0;
	this.lag		= this.LAG_VAL;
};
ShopTask.prototype = new Task();

(function( pt )
{
	pt.MENU_STRINGS	= [ "買う", "売る", "戻る" ];
	pt.LAG_VAL		= 5;

	/**
	 * 
	 */
	pt.setData = function( scene, data )
	{
		this.select	= 0;
	};
	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd = false;
		var msgManager	= scene.msgManager;
		var listTask	= scene.listTask;

		// set focus
		if ( scene.getFocus() == null )
		{
			scene.setFocus( this );
			upd = true;
		}

		if ( this.lag > 0 )
		{
			this.lag--;
		}
		else if ( this.command.tbl.left )
		{
			this.select--;
			if ( this.select < 0 )
			{
				this.select = this.MENU_STRINGS.length - 1;
			}
			listTask.select = 0;

			this.lag = this.LAG_VAL;
			upd = true;
		}
		else if ( this.command.tbl.right )
		{
			this.select++;
			if ( this.select >= this.MENU_STRINGS.length )
			{
				this.select = 0;
			}
			listTask.select = 0;

			this.lag = this.LAG_VAL;
			upd = true;
		}
		else if ( this.command.tbl.enter )
		{
			// 戻る
			if ( this.select == this.MENU_STRINGS.length - 1 )
			{
				var message	= new Message( MessageType.RET_PREV_SCENE );
				msgManager.postBreakMessage( message );
			}
			else
			{
				scene.setFocus( listTask );
			}
			this.lag = this.LAG_VAL;
			upd = true;
		}
		else if ( this.command.tbl.escape )
		{
			var message	= new Message( MessageType.RET_PREV_SCENE );
			msgManager.postBreakMessage( message );

			upd = true;
		}

		return upd;
	};
	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		var context		= scene.context;
		var canvas		= context.canvas;
		var imageData	= scene.imageData;

		var th = 20;
		var tw = 50;
		var bx = 10;
		var by = 10;
		var bw = canvas.width  - bx * 2;
		var bh = canvas.height - by * 2;

		context.save();

		// bg
		context.putImageData( imageData, 0, 0 );

		// rect
		context.fillStyle	= Res.Color.RECT;
		context.fillRect( bx, by, bw, bh );
		// border
		context.strokeStyle	= Res.Color.BORDER;
		context.beginPath();
		context.strokeRect( bx, by, bw, bh );
		// text
		context.font		= Res.Font.SMALL;
		for ( var i = 0; i < this.MENU_STRINGS.length; i++ )
		{
			if ( i == this.select && scene.getFocus() == this )
			{
				context.fillStyle	= Res.Color.FOCUS;
				context.fillRect( bx + 5 + ( i * tw ), by + 5, tw, th );
			}
			context.fillStyle	= Res.Color.FONT;
			context.fillText( this.MENU_STRINGS[i], bx + 10 + ( i * tw ), by + th );
		}

		context.restore();
	};
})( ShopTask.prototype );

/**
 * ListTask
 */
var ListTask = function( scene )
{
	this.command	= scene.command;	// input
	this.shop		= null;
	this.select		= 0;
	this.lag		= this.LAG_VAL;
};
ListTask.prototype = new Task();

(function( pt )
{
	pt.LAG_VAL	= 5;

	/**
	 * 
	 */
	pt.setData = function( scene, data, shopId )
	{
		this.select	= 0;
		this.shop	= data.item.shop[ shopId ];
	};
	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd = false;
		var msgManager	= scene.msgManager;
		var resource	= scene.data.resource;
		var sound		= scene.soundTask;
		var shopTask	= scene.shopTask;
		var list		= ( shopTask.select == 0 ) ? this.shop.items : scene.data.item.belongings;
		var itemDef		= scene.data.item.def;
		var belongings	= scene.data.item.belongings;

		if ( scene.getFocus() == this )
		{
			if ( this.lag > 0 )
			{
				this.lag--;
			}
			else if ( this.command.tbl.up )
			{
				this.select--;
				if ( this.select < 0 )
				{
					this.select = list.length - 1;
				}
				this.lag = this.LAG_VAL;
				upd = true;
			}
			else if ( this.command.tbl.down )
			{
				this.select++;
				if ( this.select >= list.length )
				{
					this.select = 0;
				}
				this.lag = this.LAG_VAL;
				upd = true;
			}
			else if ( this.command.tbl.enter )
			{
				var item	= list[ this.select ];
				var found	= -1;
				for ( var i = 0; i < belongings.length; i++ )
				{
					if ( belongings[i].id == item.id )
					{
						found = i;
						break;
					}
				}
				// 買う
				if ( shopTask.select == 0 )
				{
					if ( found >= 0 )
					{
						belongings[ found ].count++;
					}
					else
					{
						belongings.push( { id : item.id, count : 1 } );
					}
				}
				// 売る
				else
				{
					if ( found >= 0 )
					{
						belongings[ found ].count--;
						if ( belongings[ found ].count <= 0 )
						{
							belongings.splice( found, 1 );
							this.select = 0;
						}
					}
				}
				this.lag = this.LAG_VAL;
				upd = true;
			}
			else if ( this.command.tbl.escape )
			{
				scene.setFocus( null );
				this.lag = this.LAG_VAL;
				upd = true;
			}
		}
		return upd;
	};
	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		var context		= scene.context;
		var canvas		= context.canvas;
		var shopTask	= scene.shopTask;
		var list		= ( shopTask.select == 0 ) ? this.shop.items : scene.data.item.belongings;
		var itemDef		= scene.data.item.def;

		var th = 20;
		var bx = 20;
		var by = 50;
		var bw = canvas.width  - bx * 2;
		var bh = canvas.height - 110;

		context.save();

		// border
		context.strokeStyle	= Res.Color.BORDER;
		context.beginPath();
		context.strokeRect( bx, by, bw, bh );

		// list
		context.font		= Res.Font.SMALL;
		for ( var i = 0; i < list.length; i++ )
		{
			if ( i == this.select && scene.getFocus() == this )
			{
				context.fillStyle	= Res.Color.FOCUS;
				context.fillRect( bx + 5, by + 5 + ( i * th ), bw - 10, th );
			}
			context.fillStyle	= Res.Color.FONT;
			var idef	= itemDef[ list[i].id ];
			var str		= ( shopTask.select == 0 ) ?
				idef.name + " (\\" + idef.price + ")" :
				idef.name + " (x " + list[i].count + ")" ;
			context.fillText( str, bx + 10, by + th * ( i + 1 ) );
		}

		by = canvas.height - 50;
		bh = 30;
		// border
		context.strokeStyle	= Res.Color.BORDER;
		context.beginPath();
		context.strokeRect( bx, by, bw, bh );

		// desc
		if ( list.length > 0 )
		{
			context.font		= Res.Font.SMALL;
			context.fillStyle	= Res.Color.FONT;
			context.fillText( itemDef[ list[ this.select ].id ].desc, bx + 10, by + th );
		}
		context.restore();
	};
})( ListTask.prototype );


/**
 * DebugTask
 */
var DebugTask = function( scene )
{
	this.command	= scene.command;	// input
	this.info		= null;
	this.lag		= 0;
};
DebugTask.prototype = new Task();

(function( pt )
{
	pt.LAG_VAL	= 10;

	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd = false;
		// lag
		if ( this.lag )
		{
			this.lag--;
		}
		else
		{
			if ( this.command.tbl.debug )
			{
				this.info	= "viewPoint.ad.x=" + scene.viewPoint.ad.x + ", viewPoint.ad.y=" + scene.viewPoint.ad.y;
				this.lag	= this.LAG_VAL;
				upd = true;
			}
		}
		return upd;
	};

	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		// output debug info
		if ( this.info )
		{
			Debug.print( this.info );
			this.info = null;
		}
	};
})( DebugTask.prototype );

/**
 * InputCommand
 */
var InputCommand = function()
{
	this.tbl.up		= 0;
	this.tbl.left	= 0;
	this.tbl.down	= 0;
	this.tbl.right	= 0;

	this.tbl.enter	= 0;
	this.tbl.escape	= 0;
	this.tbl.debug	= 0;

	this.tbl.any	= 0;
};
InputCommand.prototype = new Command();

(function( pt )
{
	/**
	 * 
	 */
	pt.update = function() {};
	/**
	 * 
	 */
	pt.handleSysEvent = function( event )
	{
		var type = event.type.toLowerCase();
		if ( type.substring( 0, 3 ) == "key" )
		{
			var value = 0;
			if      ( type == "keydown" ) { value = 1; }
			else if ( type == "keyup"   ) { value = 0; }

			switch ( event.keyCode )
			{
				case 38: this.tbl.up	= value; event.prevent( event.orgEvent ); break;	// ↑
				case 37: this.tbl.left	= value; event.prevent( event.orgEvent ); break;	// ←
				case 40: this.tbl.down	= value; event.prevent( event.orgEvent ); break;	// ↓
				case 39: this.tbl.right	= value; event.prevent( event.orgEvent ); break;	// →

				case 13:								// ENTER
				case 90: this.tbl.enter	= value; break;	// Z
				case 27:								// ESC
				case 88: this.tbl.escape= value; break;	// X
				case 81: this.tbl.debug	= value; break;	// Q
			}
			this.tbl.any	= value;	// any key
		}
	};
})( InputCommand.prototype );

/**
 * ShopScene
 */
var ShopScene = function( app, name, stageFunc )
{
	this.app			= app;
	this.name			= name;
	this.data			= null;
	this.command		= new InputCommand();

	this.imageData		= null;

	// create task
	this.shopTask		= new ShopTask( this );
	this.listTask		= new ListTask( this );
	this.soundTask		= new SoundTask( this );
	this.debugTask		= new DebugTask( this );
	// create list
	this.shopTask.append( this.listTask );
	this.shopTask.append( this.soundTask );
	this.shopTask.append( this.debugTask );
	// head of task list
	this.child			= this.shopTask;
	this.setStatus( SceneStatus.RUNNING );

	// message handler
	this.msgManager		= new MessageManager();
	this.msgManager.addHandler( new MessageHandler( MessageType.RET_PREV_SCENE,	this, this.handleRetPrevScene ) );
};
ShopScene.prototype = new Scene();

(function( pt )
{
	/**
	 * 
	 */
	pt.handleRetPrevScene = function( scene, message )
	{
		this.app.sceneManager.pop();
		var prevScene = this.app.sceneManager.current;
		prevScene.show();
	};
	/**
	 * 
	 */
	pt.setData = function( data, shopId, imageData )
	{
		this.data		= data;
		this.imageData	= imageData;

		this.shopTask.setData( this, data );
		this.listTask.setData( this, data, shopId );
	};
	/**
	 * 
	 */
	pt.show = function()
	{
		this.setUsage( Res.String.HTML_USAGE );

		this.command.clear();
		this.holdContext();
		this.draw( this );
	};
})( ShopScene.prototype );


// Expose
if ( !window.h5glib ) { window.h5glib = {}; }
window.h5glib.ShopScene	= ShopScene;

// Anonymous function end
//
})( window );
