﻿Imports System.Runtime.Remoting.Channels.Ipc
Imports System.Runtime.Remoting.Channels
Imports System.Runtime.Remoting
Imports System.Threading

Class Application

    ' 多重起動用ミューティックス名称
    Private Const MUTEX_NAME As String = "HachiLauncher_0.0.0"

    ' 多重起動用ミューティックス
    Private Shared mProcessMutex As Mutex


    ''' <summary>アプリケーション起動イベント。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="e">イベントオブジェクト。</param>
    ''' <remarks>
    ''' 多重起動を禁止し、後発のプロセスよりイベントを受け取るための口を開く。
    ''' </remarks>
    Private Sub Application_Startup(sender As Object, e As StartupEventArgs) Handles Me.Startup
        ' 名前を指定してMutexを生成
        mProcessMutex = New Mutex(False, MUTEX_NAME)

        ' 多重起動をチェック
        '   起動されていたらメッセージをアプリケーションに渡す
        If Not mProcessMutex.WaitOne(0, False) Then
            mProcessMutex = Nothing
            Dim clCannel As New IpcClientChannel()
            ChannelServices.RegisterChannel(clCannel, True)
            Dim smsg As RemoteMsg = DirectCast(Activator.GetObject(GetType(RemoteMsg), "ipc://hachi_launcher/message"), RemoteMsg)
            Dim args() As String = System.Environment.GetCommandLineArgs()
            Dim page As Integer = 0
            If args.Length >= 2 AndAlso Integer.TryParse(args(1), page) Then
                smsg.CallMsg(page)
            Else
                smsg.CallMsg(0)
            End If

            Me.Shutdown()
        End If
    End Sub

    ''' <summary>アプリケーション終了イベント。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="e">イベントオブジェクト。</param>
    Private Sub Application_Exit(sender As Object, e As ExitEventArgs) Handles Me.Exit
        If mProcessMutex IsNot Nothing Then
            mProcessMutex.ReleaseMutex()
            mProcessMutex.Close()
        End If
    End Sub

#Region "properties"

    ''' <summary>アプリケーションのデータフォルダパス。</summary>
    ''' <value>文字列型。</value>
    Public Shared ReadOnly Property APPDATA_PATH() As String
        Get
            Return String.Format("{0}\HachiLauncher", System.Environment.GetEnvironmentVariable("APPDATA"))
        End Get
    End Property

    ''' <summary>XMLデータファイルパス。</summary>
    ''' <value>文字列型。</value>
    Public Shared ReadOnly Property XML_FILE_PATH() As String
        Get
            Return String.Format("{0}\icon_setting.xml", APPDATA_PATH)
        End Get
    End Property

#End Region

End Class
