﻿Option Strict On
Option Explicit On

Imports System.ComponentModel

''' <summary>ウィンドウヘッダーコントロール。</summary>
''' <remarks>
''' ウィンドウの上部に配置され、「閉じるボタン」と「設定ボタン」、「タイトル」を表示する。
''' </remarks>
Public NotInheritable Class HeaderBarControl
    Implements INotifyPropertyChanged

#Region "events"

    ''' <summary>プロパティ変更イベント。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="e">イベントオブジェクト。</param>
    Public Event PropertyChanged(sender As Object, e As PropertyChangedEventArgs) Implements INotifyPropertyChanged.PropertyChanged

    ''' <summary>マウスダウンイベント。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="e">イベントオブジェクト。</param>
    Public Event NotifyMouseDown(sender As Object, e As MouseButtonEventArgs)

    ''' <summary>クローズボタンクリックイベント。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="senderbutton">クリックされたボタン。</param>
    Public Event NotifyCloseButtonClick(sender As Object, senderbutton As Object)

    ''' <summary>設定ボタンクリックイベント。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="senderbutton">クリックされたボタン。</param>
    Public Event NotifySettingButtonClick(sender As Object, senderbutton As Object)

#End Region

    ' マウスクリック
    Private Sub UserControl_MouseDown(sender As Object, e As MouseButtonEventArgs)
        RaiseEvent NotifyMouseDown(Me, e)
    End Sub

    ' クローズボタンクリック
    Private Sub CloseButton_Click(sender As Object, e As RoutedEventArgs)
        RaiseEvent NotifyCloseButtonClick(Me, sender)
        e.Handled = True
    End Sub

    ' 設定ボタンクリック
    Private Sub SettingButton_Click(sender As Object, e As RoutedEventArgs)
        RaiseEvent NotifySettingButtonClick(Me, sender)
        e.Handled = True
    End Sub

#Region "properties"

    ''' <summary>ヘッダタイトル。</summary>
    ''' <value>文字列型。</value>
    Public Property Title() As String
        Get
            Return Me.titleTextBlock.Text
        End Get
        Set(value As String)
            Me.titleTextBlock.Text = value
            RaiseEvent PropertyChanged(Me, New PropertyChangedEventArgs(value))
        End Set
    End Property

#End Region

End Class
