﻿Option Explicit On
Option Strict On

Imports System.ComponentModel

''' <summary>設定パネルコントロール。</summary>
''' <remarks>
''' 設定、及び、複数のサービスを提供する。
''' </remarks>
Public NotInheritable Class SettingPanelControl
    Implements INotifyPropertyChanged

#Region "events"

    ''' <summary>プロパティ変更イベント。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="e">イベントオブジェクト。</param>
    Public Event PropertyChanged(sender As Object, e As PropertyChangedEventArgs) Implements INotifyPropertyChanged.PropertyChanged

    ''' <summary>背景色の変更を外部に通知する。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="newColor">新しい色。</param>
    Public Event ChangedColor(sender As Object, newColor As Color)

    ''' <summary>クリックののち自動で隠すの設定変更イベント。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="newValue">新しい値。</param>
    Public Event ChangeHideClickAfter(sender As Object, newValue As Boolean)

    ''' <summary>タスクバーに表示するの変更イベント。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="newValue">新しい値。</param>
    Public Event ChangeShowTaskbar(sender As Object, newValue As Boolean)

    ''' <summary>自動隠しモードの設定変更イベント。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="newMode">新しいモード。</param>
    Public Event ChangeAutoHideMode(sender As Object, newMode As Integer)

#End Region

    ' 透過ウィンドウカラーブラシ
    Private mWindowColor As SolidColorBrush

    ' パネルカラーブラシ
    Private mPanelColor As SolidColorBrush

    ''' <summary>コンストラクタ。</summary>
    Public Sub New()
        InitializeComponent()
        Me.DataContext = Me
    End Sub

    ''' <summary>背景色設定。</summary>
    ''' <param name="r">赤成分。</param>
    ''' <param name="g">緑成分。</param>
    ''' <param name="b">青成分。</param>
    ''' <remarks>背景色の設定を行う。</remarks>
    Public Sub SetColor(r As Byte, g As Byte, b As Byte)
        Me.mWindowColor = New SolidColorBrush(Color.FromArgb(200, r, g, b))
        Me.mPanelColor = New SolidColorBrush(Color.FromArgb(255, r, g, b))
        RaiseEvent PropertyChanged(Me, New PropertyChangedEventArgs(""))
    End Sub

    ''' <summary>背景色設定。</summary>
    ''' <param name="newColor">新しい色。</param>
    ''' <remarks>背景色の設定を行う。</remarks>
    Public Sub SetColor(newColor As Color)
        With newColor
            Me.SetColor(.R, .G, .B)
        End With
    End Sub

    ''' <summary>背景色変更イベントハンドラ。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="e">イベントオブジェクト。</param>
    Private Sub ColorChangeButton_Click(sender As Object, e As RoutedEventArgs)
        Dim btn As Button = DirectCast(sender, Button)
        With DirectCast(btn.Background, SolidColorBrush)
            Me.SetColor(.Color)
            RaiseEvent ChangedColor(Me, .Color)
        End With
        e.Handled = True
    End Sub

    ''' <summary>閉じるボタンクリックイベントハンドラ。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="e">イベントオブジェクト。</param>
    Private Sub CloseButton_Click(sender As Object, e As RoutedEventArgs)
        Application.Current.Shutdown()
    End Sub

#Region "properties"

    ''' <summary>透過ウィンドウカラーブラシ。</summary>
    ''' <value>カラーブラシ。</value>
    Public ReadOnly Property WindowColor() As SolidColorBrush
        Get
            Return Me.mWindowColor
        End Get
    End Property

    ''' <summary>パネルカラーブラシ。</summary>
    ''' <value>カラーブラシ。</value>
    Public ReadOnly Property PanelColor() As SolidColorBrush
        Get
            Return Me.mPanelColor
        End Get
    End Property

    Public ReadOnly Property ShowTaskbar() As Boolean
        Get
            Dim val As Boolean = CBool(Me.taskClick.IsChecked)
            Return val
        End Get
    End Property

#End Region

    Public Sub SetHideClickAfter(value As Boolean)
        Me.hideClick.IsChecked = value
    End Sub

    Private Sub hideClick_Click(sender As Object, e As RoutedEventArgs) Handles hideClick.Click
        Dim val As Boolean = CBool(Me.hideClick.IsChecked)
        RaiseEvent ChangeHideClickAfter(Me, val)
    End Sub

    Public Sub SetAutoHideMode(value As Integer)
        Dim rdo() As RadioButton = {
            Me.radio_0, Me.radio_1, Me.radio_2, Me.radio_3
        }
        rdo(value).IsChecked = True
    End Sub

    Private Sub radio_Checked(sender As Object, e As RoutedEventArgs) Handles radio_0.Checked, radio_1.Checked, radio_2.Checked, radio_3.Checked
        Dim rdo() As RadioButton = {
            Me.radio_0, Me.radio_1, Me.radio_2, Me.radio_3
        }

        Dim newMd As Integer = 0
        For i As Integer = 0 To rdo.Length - 1
            Dim f As Boolean = CBool(rdo(i).IsChecked)
            If f Then
                newMd = i
                Exit For
            End If
        Next

        RaiseEvent ChangeAutoHideMode(Me, newMd)
    End Sub

    Public Sub SetShowTaskbar(value As Boolean)
        Me.taskClick.IsChecked = value
    End Sub

    Private Sub taskClick_Checked(sender As Object, e As RoutedEventArgs) Handles taskClick.Click
        Dim val As Boolean = CBool(Me.taskClick.IsChecked)
        RaiseEvent ChangeShowTaskbar(Me, val)
    End Sub

End Class

