﻿Option Explicit On
Option Strict On

''' <summary>下部操作パネルコントロール。</summary>
''' <remarks>
''' アイコンの特殊操作用コントロール。
''' </remarks>
Public NotInheritable Class UnderPanelControl

#Region "events"

    ''' <summary>アイコン削除通知イベント。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <remarks>アイコン削除ボタンを押下したことを通知する。</remarks>
    Public Event NotifyRemoveIcon(sender As Object)

    ''' <summary>管理者として実行を通知するイベント。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <remarks>管理者として実行する操作を行ったことを通知する。</remarks>
    Public Event NotifyAdministratorRun(sender As Object)

    ''' <summary>アイコン名の編集が終了したことを通知するイベント。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <remarks>アイコン名の編集が終了したことを通知する。</remarks>
    Public Event NotifyEditFinish(sender As Object)

#End Region

    ' 削除操作イベントハンドラ
    Private Sub RemoveButton_Click(sender As Object, e As RoutedEventArgs)
        RaiseEvent NotifyRemoveIcon(Me)
    End Sub

    ' 管理者として実行イベントハンドラ
    Private Sub AdminButton_Click(sender As Object, e As RoutedEventArgs)
        RaiseEvent NotifyAdministratorRun(Me)
    End Sub

    ' 名前編集キーダウンイベントハンドラ
    Private Sub editIcpnName_PreviewKeyDown(sender As Object, e As KeyEventArgs) Handles editIcpnName.PreviewKeyDown
        ' Enterキーを押下したら、編集終了を通知
        If e.Key = Key.Enter Then
            RaiseEvent NotifyEditFinish(Me)
        End If
    End Sub

#Region "properties"

    ''' <summary>操作対象のアイコン名称。</summary>
    ''' <value>文字列型。</value>
    Public Property IconNameText() As String
        Get
            Return Me.editIcpnName.Text
        End Get
        Set(value As String)
            Me.editIcpnName.Text = value
            Me.editIcpnName.SelectAll()
        End Set
    End Property

#End Region

End Class
