// main_window_class.cpp: main window for action_game

// Copyright Takeshi Mouri 2007, 2008.
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

// See http://hamigaki.sourceforge.jp/ for library home page.

#include <hamigaki/system/windows_error.hpp>
#include "main_window_impl.hpp"
#include "main_window.hpp"

using hamigaki::system::windows_error;

namespace
{

::LRESULT CALLBACK window_proc(
    ::HWND hwnd, ::UINT uMsg, ::WPARAM wParam, ::LPARAM lParam)
{
    try
    {
        main_window* pimpl =
            reinterpret_cast<main_window*>(
                GetWindowLongPtr(hwnd, GWLP_USERDATA)
            );

        if (uMsg == WM_CREATE)
        {
            ::CREATESTRUCTA& data =
                *reinterpret_cast< ::CREATESTRUCTA*>(lParam);

            const game_project& proj =
                *reinterpret_cast<const game_project*>(data.lpCreateParams);

            pimpl = new main_window(hwnd, proj);
            SetWindowLongPtr(
                hwnd, GWLP_USERDATA, reinterpret_cast< ::LONG_PTR>(pimpl));
        }
        else if (uMsg == WM_DESTROY)
        {
            SetWindowLongPtr(hwnd, GWLP_USERDATA, 0);
            delete pimpl;
            ::PostQuitMessage(0);
        }
        else if (uMsg == WM_ACTIVATEAPP)
        {
            if (pimpl)
                pimpl->active(wParam != FALSE);
        }
    }
    catch (const std::exception& e)
    {
        ::MessageBoxA(hwnd, e.what(), "Action Game", MB_OK);
    }
    return ::DefWindowProc(hwnd, uMsg, wParam, lParam);
}

} // namespace

::ATOM register_main_window_class(::HINSTANCE hInstance)
{
    ::WNDCLASSEXA wc;
    std::memset(&wc, 0, sizeof(wc));
    wc.cbSize = sizeof(wc);
    wc.style = CS_CLASSDC;
    wc.lpfnWndProc = &window_proc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = sizeof(::LONG_PTR);
    wc.hInstance = hInstance;
    wc.hIcon = ::LoadIcon(0, IDI_APPLICATION);
    wc.hCursor = ::LoadCursor(0, IDC_ARROW);
    wc.hbrBackground = 0;
    wc.lpszMenuName = 0;
    wc.lpszClassName = "MainWindow";
    wc.hIconSm = 0;

    ::ATOM cls = ::RegisterClassExA(&wc);
    if (cls == 0)
        throw windows_error(::GetLastError(), "RegisterClassExA()");

    return cls;
}

::HWND
create_main_window(::HINSTANCE hInstance, ::ATOM cls, const game_project& proj)
{
    ::DWORD style = WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX;
    ::DWORD ex_style = 0;

    ::RECT r = { 0, 0, proj.screen_width, proj.screen_height };
    ::AdjustWindowRectEx(&r, style, FALSE, ex_style);

    std::string title = proj.title;
    if (title.empty())
        title = "Action Game";

    ::HWND hwnd = ::CreateWindowExA(
        ex_style, MAKEINTATOM(cls), title.c_str(), style,
        CW_USEDEFAULT, CW_USEDEFAULT, r.right - r.left, r.bottom - r.top,
        0, 0, hInstance, const_cast<game_project*>(&proj)
    );
    if (hwnd == 0)
        throw windows_error(::GetLastError(), "CreateWindowExA()");

    return hwnd;
}

void connect_d3d_device(::HWND hwnd)
{
    main_window* pimpl =
        reinterpret_cast<main_window*>(
            GetWindowLongPtr(hwnd, GWLP_USERDATA)
        );

    if (pimpl)
        pimpl->connect_d3d_device();
}

bool process_input(::HWND hwnd)
{
    main_window* pimpl =
        reinterpret_cast<main_window*>(
            GetWindowLongPtr(hwnd, GWLP_USERDATA)
        );

    if (pimpl)
        return pimpl->process_input();
    else
        return false;
}

void render(::HWND hwnd)
{
    main_window* pimpl =
        reinterpret_cast<main_window*>(
            GetWindowLongPtr(hwnd, GWLP_USERDATA)
        );

    if (pimpl)
        pimpl->render();
}
