#! C:\Perl\bin\perl
#
# usage: perl namerecords2namettx.pl namerecords > name.ttx

use strict;
use warnings;
use utf8;
binmode STDOUT, ":utf8";

use Encode;

my $id_table = {
  mac => {
    en => { pratform_id => 1, encoding_id => 0, language_id => "0x0"    },
    ja => { pratform_id => 1, encoding_id => 1, language_id => "0xb"    },
    ps => { pratform_id => 1, encoding_id => 1, language_id => "0xffff" },
  },
  win => {
    en => { pratform_id => 3, encoding_id => 1, language_id => "0x409"  },
    ja => { pratform_id => 3, encoding_id => 1, language_id => "0x411"  },
  },
};


my @namerecords = ();

# namerecords読み込み

open(IN, "<:utf8", $ARGV[0]) or die "$!";
while (<IN>) {
  chomp;
  if (m/^\s*(\d+)\s(mac|win)\s(en|ja|ps)\s+(.*)$/) {
    push @namerecords, { name_id => $1, pratform => $2, language => $3, value => $4 };
  }
}
close(IN);


# ttx生成

my $ttx = <<"HEADER";
<?xml version="1.0" encoding="UTF-8"?>
<ttFont ttLibVersion="2.2">
  <name>
HEADER

foreach my $nr (@namerecords) {
  my $ids = $id_table->{$nr->{pratform}}{$nr->{language}};
  $ids->{name_id} = $nr->{name_id};
  my $value = ($ids->{language_id} eq "0xb") ? encode_to_macj_charref($nr->{value}) : encode_to_uni_charref($nr->{value});
  $ttx .= <<"NAMERECORD";
    <namerecord nameID="$ids->{name_id}" platformID="$ids->{pratform_id}" platEncID="$ids->{encoding_id}" langID="$ids->{language_id}">
      $value
    </namerecord>
NAMERECORD
}

$ttx .= <<"FOOTER";
  </name>
</ttFont>
FOOTER

print $ttx;

exit;


# MacJapaneseバイト列の数値参照に変換
sub encode_to_macj_charref {
  my $str = shift;
  my $macj = unpack "H*", encode("MacJapanese", $str);
  $macj =~ s/(..)/&#x$1;/g;
  return $macj;
}

# ascii以外の文字を数値文字参照に変換（&<>はエスケープ）
sub encode_to_uni_charref {
  my $uni = shift;
  $uni =~ s/&/&amp;/g;
  $uni =~ s/</&lt;/g;
  $uni =~ s/>/&gt;/g;
  $uni = encode('ascii', $uni, Encode::XMLCREF);
  return $uni;
}

__END__
