::
:: usage: makecidotf [-t] pua.otf version
::

@echo off

setlocal

::引数チェック
if "%2" == "" (
  goto print_usage
)
if "%1" == "-t" (
  if "%3" == "" (
    goto print_usage
  ) else (
    set RESERVE_TEMP=1
    shift /1
  )
)

set BAT_DIR=%~dp0
set PUA_OTF=%~f1
set REPLACE_VERSION="s/##version##/%2/g"

pushd makecidotf

  if not exist temp (mkdir temp)

  :: フォントをマージしてCIDキー方式のフォントに
  perl -pe %REPLACE_VERSION% cidfontinfo > temp\cidfontinfo
  mergeFonts -cid temp\cidfontinfo temp\merged.otf map\generic.map hikanji\Generic.otf map\aj16pua.map %PUA_OTF%
  if errorlevel 1 goto final
  
  :: featureファイルをコピー
  if not exist temp\fea (mkdir temp\fea)
  copy fea\* temp\fea\
  perl -pe %REPLACE_VERSION% features > temp\features

  pushd temp
  
    :: 収録グリフの一覧を出力し、それを元にaalt.feaを生成
    tx -dump -4 merged.otf > glyphlist.txt
    perl fea\make_aalt.pl glyphlist.txt fea\aalt_all.fea > fea\aalt.fea
  
    :: makeotfでフォントを生成
    copy ..\FontMenuNameDB FontMenuNameDB
    call makeotf -f merged.otf -ff features -o temp.otf ^
      -ch ..\cmap\UniJIS2004-UTF32-H -cv ..\cmap\UniJIS2004-UTF32-V ^
      -ci ..\cmap\Adobe-Japan1_sequences.txt

    :: namerecordsからname.ttxを生成してnameテーブル書き換え
    perl -pe %REPLACE_VERSION% ..\namerecords > namerecords
    perl ..\namerecords2namettx.pl namerecords > name.ttx
    call ttx -m temp.otf name.ttx
    
    :: ファイル名変更、移動
    for /f %%a in ('perl -ne "print $1 if /\[(.+)\]/" FontMenuNameDB') do set PSNAME=%%a
    move name.ttf %BAT_DIR%%PSNAME%.otf
  
  popd
  
  :final
  
  :: -tが指定されていなければtempディレクトリを削除
  if not defined RESERVE_TEMP (
    rmdir /s /q temp
  )
  
popd

goto end

:print_usage
echo usage: makecidotf [-t] pua.otf version
echo;
echo [option]
echo     -t  Do not delete makecidotf\temp\
echo;

:end