#!/usr/bin/env python
# -*- coding: utf-8 -*- 
# TranslateStringsFile.py
#
#

import os, sys, re, codecs

#fo_in = codecs.lookup("utf_16")[-1](sys.stdin)
fo_in = sys.stdin
string_table = []

re_comment = re.compile( r"^/\* (.*) \*/" )
re_string = re.compile( r"\"(.*)([^\\])\" = \"(.*)([^\\])\";" )
re_blank = re.compile( r"^\s*$" )

comment = ""
key = ""
value = ""

# read translate table
if len(sys.argv) < 2:
    sys.stderr.write( "%s <TranslateTable.txt>" % sys.argv[0] )
    sys.exit(-1)

fo_table = open( sys.argv[1], "r" )
translate_table = {}
for line in fo_table:
    line = line.rstrip()
    list = line.split("\t")
    key = list[0]
    value = list[1]
    if len(list) > 2:
        comment = list[2]
    else:
        comment = ""
    translate_table[key] = {"value":value, "comment":comment}

fo_table.close()


for line in fo_in:
    line = line.rstrip()

    if re_blank.search( line ):
      if (comment) and (key):
          if translate_table.has_key(key):
              translate = translate_table[key]
              value = translate["value"]
          print "/* %s */" % (comment)
          print "\"%s\" = \"%s\";\n" % (key, value)
#          print key
#          print value
          comment = ""
          key = ""
          value = ""
      elif (comment):
          print "/* %s */" % (comment)
          comment = ""
      continue

    elif re_comment.search( line ):
        comment = re_comment.search( line ).group(1)

    elif re_string.search( line ):
        mt = re_string.search( line )
        key = mt.group(1) + mt.group(2)
        value = mt.group(3) + mt.group(4)

#    print line
#    print ">", comment, key, value
