# coding: UTF-8

require 'erb'
require 'graphviz'

def getIncludeGuardName(name)
	while name =~ /^(.+)([a-z0-9])([A-Z])(.+)$/
		name = "#{$1}#{$2}_#{$3}#{$4}"
	end
	return name.upcase
end

if ARGV[0] =~ /(.+)\.dot/ then
	grammarName = "#{$1}Grammar"
	grammarNameCamelized = "#{grammarName.slice(0, 1).upcase}#{grammarName.slice(1, grammarName.size - 1)}"
	grammarIncludeGuardName = getIncludeGuardName(grammarName)
	cpp_filename = "#{grammarNameCamelized}.cpp"
	hpp_filename = "#{grammarNameCamelized}.hpp"
end

def getPhraseFromEdgeLabel(label)
	# ダブルクオーテーションがあれば削除する
	if label =~ /"(.+)"/ then
		label = $1
	end

	# パラメータがあるかどうかを確認する
	if label =~ /(.+)(\(.+\))/ then
		phrase = getUTF8Name($1)
		parameter = $2
		if parameter =~ /^\s*([-]?[1-9][0-9]*)\s*$/ then
			return [phrase, $1.to_i, nil]
		elsif parameter =~ /^\s*'(.+)'\s*$/ then
			return [phrase, nil, $1]
		elsif parameter =~ /^\s*([-]?[1-9][0-9]*)\s*,\s*'(.+)'\s*/ then
			return [phrase, $1.to_i, $2]
		end
	end

	return [label, nil, nil]
end

def getNodeName(name)
	if name == "start" then
		return "START_STATE_NAME"
	elsif name == "finish" then
		return "FINISH_STATE_NAME"
	else
		return "\"#{name}\""
	end
end

cpp_template = <<END
/**
 * dot2grammar generated.
 */

#ifdef _MSC_VER
#pragma warning(disable:4996)
#endif

#include "<%= hpp_filename %>"

#include <spcf/core/GrammarPhrase.hpp>
#include <spcf/core/GrammarTransition.hpp>

using namespace std;

void setGrammar(<%= grammarNameCamelized %>& self, const string* propertyName);

<%= grammarNameCamelized %>::<%= grammarNameCamelized %>(const string& name) : GrammarCommonImpl(name) {
	setGrammar(*this, style, 0);
}

<%= grammarNameCamelized %>::<%= grammarNameCamelized %>(const string& name, const string& propertyName) : GrammarCommonImpl(name) {
	setGrammar(*this, style, &propertyName);
}

<%= grammarNameCamelized %>::~<%= grammarNameCamelized %>() {
}

void setGrammar(<%= grammarNameCamelized %>& grammar, const string* propertyName) {
	<%-
	i = 0
	graph.each_edge do |edge|
		(phrase, propertyInt, propertyString) = getPhraseFromEdgeLabel(edge['label'].source.encode('Shift_JIS', 'UTF-8'))
		startState = getNodeName(edge.node_one)
		endState = getNodeName(edge.node_two)
	-%>
	GrammarTransitionPtr t<%= i %> = grammar.addGrammarTransition("<%= phrase %>", <%= startState %>, <%= endState %>);
		<%- if propertyInt != nil && propertyString != nil then -%>
	if (propertyName) {
		t<%= i %>->getPhrase()->setProperty(*propertyName, <%= propertyInt %>, "<%= propertyString %>");
	}
		<%- elsif propertyInt != nil then -%>
	if (propertyName) {
		t<%= i %>->getPhrase()->setProperty(*propertyName, <%= propertyInt %>);
	}
		<%- elsif propertyString != nil then -%>
	if (propertyName) {
		t<%= i %>->getPhrase()->setProperty(*propertyName, "<%= propertyString %>");
	}
		<%- end -%>
	<%-
		i = i + 1
	end
	-%>
}
END

hpp_template = <<END
/**
 * dot2grammar generated.
 */

#ifndef _<%= grammarIncludeGuardName %>_HPP_
#define _<%= grammarIncludeGuardName %>_HPP_

#include <spcf/grammar/GrammarCommonImpl.hpp>

class <%= grammarNameCamelized %> : public GrammarCommonImpl {
public:
	<%= grammarNameCamelized %>(const std::string& name);
	<%= grammarNameCamelized %>(const std::string& name, const std::string& propertyName);
	virtual ~<%= grammarNameCamelized %>();
};

#endif
END

graph = GraphViz::parse(ARGV[0])

open(cpp_filename, "w") do |f|
	f.set_encoding('UTF-8', 'UTF-8')
	f.write(ERB.new(cpp_template, nil, '-').result(binding))
end
open(hpp_filename, "w") do |f|
	f.set_encoding('UTF-8', 'UTF-8')
	f.write(ERB.new(hpp_template, nil, '-').result(binding))
end
