/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: GrammarPhrase.hpp 52 2011-05-17 06:24:31Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _SPEECH_CONTROLLER_FRAMEWORK_CORE_GRAMMAR_PHRASE_HPP_
#define _SPEECH_CONTROLLER_FRAMEWORK_CORE_GRAMMAR_PHRASE_HPP_

#include <string>

namespace spcf {

	class GrammarPhrase_i;

	class GrammarPhrase {
	private:
		GrammarPhrase_i *impl;

	public:
		GrammarPhrase();
		virtual ~GrammarPhrase();

	private:
		GrammarPhrase(const GrammarPhrase& phrase);
		GrammarPhrase& operator=(const GrammarPhrase& phrase);

	public:
		GrammarPhrase(const std::string& phrase);
		GrammarPhrase(const std::string& phrase, const std::string& name);
		GrammarPhrase(const std::string& phrase, const std::string& name, int propertyInt);
		GrammarPhrase(const std::string& phrase, const std::string& name, const std::string& propertyString);
		GrammarPhrase(const std::string& phrase, const std::string& name, int propertyInt, const std::string& propertyString);

	public:
		const std::string& getPhrase() const;

		bool hasProperty() const;

		const std::string& getPropertyName() const;

		bool hasPropertyInt() const;

		const int& getPropertyInt() const;

		bool hasPropertyString() const;

		const std::string& getPropertyString() const;

		void setProperty(const std::string& name);
		void setProperty(const std::string& name, int propertyInt);
		void setProperty(const std::string& name, const std::string& propertyString);
		void setProperty(const std::string& name, int propertyInt, const std::string& propertyString);

		void clearProperty();
	};

}  // namespace spcf

#endif
