/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: GrammarTransition.hpp 23 2011-05-10 02:25:55Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _SPEECH_CONTROLLER_FRAMEWORK_CORE_GRAMMAR_TRANSITION_HPP_
#define _SPEECH_CONTROLLER_FRAMEWORK_CORE_GRAMMAR_TRANSITION_HPP_

#include "spcf/core/Grammar.hpp"

namespace spcf {

	class GrammarPhrase;
	typedef boost::shared_ptr<GrammarPhrase> GrammarPhrasePtr;

	class GrammarTransition_i;

	class GrammarTransition {
	private:
		GrammarTransition_i* impl;

	public:		
		GrammarTransition(const GrammarPhrasePtr& phrase, const Grammar::State& start, const Grammar::State& end);
		virtual ~GrammarTransition();

	private:
		GrammarTransition(const GrammarTransition& grammarTransition);
		const GrammarTransition& operator=(const GrammarTransition& grammarTransition);

	public:
		const GrammarPhrasePtr& getPhrase() const;
		const Grammar::State& getStartState() const;
		const Grammar::State& getEndState() const;
	};

}  // namespace spcf

#endif
