/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: EngineFactory.cpp 32 2011-05-11 12:48:01Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#include "spcf/engine-factory/EngineFactory.hpp"

#include "spcf/sapi/SAPIEngine.hpp"

using namespace boost;
using namespace std;

namespace spcf {

	string EngineFactory::SAPI_ENGINE("sapi_engine");

	EnginePtr EngineFactory::getEngine(const string& name) {
		return getEngine(name, map<string, any>());
	}

	EnginePtr EngineFactory::getEngine(const string& name, const map<string, any>& properties) {
		if (EngineFactory::SAPI_ENGINE == name) {
			return EnginePtr(new SAPIEngine());
		} else {
			return EnginePtr();
		}
	}

}  // namespace spcf
