/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: Char2WChar.hpp 12 2011-05-05 00:59:46Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _WINDOWS_CHAR_TO_WIDE_CHAR_HPP_
#define _WINDOWS_CHAR_TO_WIDE_CHAR_HPP_

#include <windows.h>

#include <string>

namespace spcf {

	/**
	 * LN^ChLN^ɕϊ郉bp[łB
	 *
	 * @author gDC[
	 */
	class Char2WChar {
	private:
		WCHAR* buffer_;

	public:
		Char2WChar() : buffer_(0) {
		}
		Char2WChar(const std::string& source);
		~Char2WChar();

	private:
		void copy(WCHAR* buffer);

	public:
		explicit Char2WChar(const Char2WChar& c) {
			if(buffer_) delete[] buffer_;
			copy(c.buffer_);
		}
		Char2WChar& operator=(const Char2WChar& c) {
			if(buffer_) delete[] buffer_;
			copy(c.buffer_);
			return *this;
		}

	public:
		operator WCHAR*() const {
			return buffer_;
		}
	};

}  // namespace spcf

#endif
