/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: SAPIEngine.cpp 64 2011-05-21 01:55:09Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifdef _MSC_VER
#pragma warning(disable:4996)
#endif

#include "spcf/sapi/SAPIEngine.hpp"

#include "spcf/core/Controller.hpp"
#include "spcf/core/Grammar.hpp"
#include "spcf/core/GrammarPhrase.hpp"
#include "spcf/core/GrammarTransition.hpp"
#include "spcf/sapi/SAPIRecognition.hpp"
#include "spcf/sapi/utils/Char2WChar.hpp"
#include "spcf/sapi/utils/Phrase.hpp"

#include <sphelper.h>

#include <objbase.h>
#include <windows.h>

#include <map>
#include <stdexcept>
using namespace std;

namespace spcf {

	typedef map<std::string, GrammarPtr> GrammarMap;
	typedef map<Grammar::State, SPSTATEHANDLE> StateMap;
	typedef pair<Grammar::State, SPSTATEHANDLE> StatePair;

	class SAPIEngine_i : public ISpNotifyCallback {
	public:
		SAPIEngine& self_;
		const ULONGLONG guid_;
		HRESULT lastResult_;
		CComPtr<ISpRecognizer> recognizer_;
		CComPtr<ISpRecoContext> context_;
		CComPtr<ISpRecoGrammar> grammar_;
		CComPtr<ISpAudio> audio_;
		GrammarMap grammarMap_;

		SAPIEngine_i(SAPIEngine& self, const ULONGLONG guid) : self_(self), guid_(guid) {
		}

	public:
		void insertStateMap(StateMap& stateMap, SPSTATEHANDLE topState, const std::string& stateName);

	public:
		HRESULT STDMETHODCALLTYPE NotifyCallback(WPARAM wParam, LPARAM lParam);

	protected:
		HRESULT recognized(CSpEvent& event);
		HRESULT soundStarted(CSpEvent& event);
		HRESULT soundStoped(CSpEvent& event);
	};

	SAPIEngine::SAPIEngine() : impl(new SAPIEngine_i(*this, 0)) {
	}

	SAPIEngine::~SAPIEngine() {
	}

	void SAPIEngine::init() {
		// COM
		if (FAILED(CoInitialize(NULL))) {
			throw domain_error("COM ̏Ɏs܂B");
		}

		// FGW𐶐
		if (FAILED(impl->lastResult_ = impl->recognizer_.CoCreateInstance(CLSID_SpInprocRecognizer))) {
			throw domain_error("FGW̐Ɏs܂B");
		}

		// FReLXg𐶐
		if (FAILED(impl->lastResult_ = impl->recognizer_->CreateRecoContext(&impl->context_))) {
			throw domain_error("FReLXg̐Ɏs܂B");
		}

		// ʒm̎Mݒ肷
		if (FAILED(impl->lastResult_ = impl->context_->SetNotifyCallbackInterface(impl, 0, 0))) {
			throw domain_error("ʒm̎MݒɎs܂B");
		}

		// MCxg̎ނw肷
		const ULONGLONG interest=
		    SPFEI(SPEI_RECOGNITION) | SPFEI(SPEI_SOUND_START) | SPFEI(SPEI_SOUND_END);
		if (FAILED(impl->lastResult_ = impl->context_->SetInterest(interest, interest))) {
			throw domain_error("ʒmCxg̎ނ̐ݒɎs܂B");
		}

		// I[fBIf[^M悤ɐݒ肷
		if (FAILED(impl->lastResult_ = impl->context_->SetAudioOptions(SPAO_RETAIN_AUDIO, NULL, NULL))) {
			throw domain_error("I[fBIf[^̎MݒɎs܂B");
		}

		// ftHgI[fBIIuWFNg\z
		if (FAILED(impl->lastResult_ = SpCreateDefaultObjectFromCategoryId(SPCAT_AUDIOIN, &impl->audio_))) {
			throw domain_error("ftHgI[fBIIuWFNg̐Ɏs܂B");
		}

		// FGWւ̓͂ݒ肷
		if (FAILED(impl->lastResult_ = impl->recognizer_->SetInput(impl->audio_, TRUE))) {
			throw domain_error("FGWւ̓͐ݒɎs܂B");
		}

		// @\z
		if (FAILED(impl->lastResult_ = impl->context_->CreateGrammar(impl->guid_, &impl->grammar_))) {
			throw domain_error("@̐Ɏs܂B");
		}
	}

	void SAPIEngine::start() {
		// FGW𓮍삳
		if (FAILED(impl->lastResult_ = impl->recognizer_->SetRecoState(SPRST_ACTIVE))) {
			throw domain_error("FGW̋NɎs܂B");
		}

		// EBhEbZ[W
		MSG msg;
		while (GetMessage(&msg, NULL, 0, 0)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	void SAPIEngine::stop() {
		// FGW~
		if (FAILED(impl->lastResult_ = impl->recognizer_->SetRecoState(SPRST_INACTIVE))) {
			throw domain_error("FGW̒~Ɏs܂B");
		}

		PostMessage(NULL, WM_QUIT, 0, 0);
	}

	void SAPIEngine::destroy() {
		CoUninitialize();
	}

	void SAPIEngine::addGrammar(const GrammarPtr& grammar) {
		// ꎞIɕ@𖳌ɂ
		if (FAILED(impl->lastResult_ = impl->grammar_->SetGrammarState(SPGS_DISABLED))) {
			throw domain_error("@̖Ɏs܂B");
		}

		// [\z
		StateMap stateMap;
		SPSTATEHANDLE topState;
		if (FAILED(impl->lastResult_ = impl->grammar_->GetRule(Char2WChar(grammar->getName()), 0, SPRAF_TopLevel | SPRAF_Active, TRUE, &topState))) {
			throw domain_error("@̃[̐Ɏs܂B");
		}
		stateMap.insert(pair<Grammar::State, SPSTATEHANDLE>(Grammar::START_STATE_NAME, topState));

		// @\z
		for (
			Grammar::GrammarTransitionList::const_iterator i = grammar->beginTransitions();
			i != grammar->endTransitions(); ++i)
		{
			const GrammarTransitionPtr& transition = *i;
			impl->insertStateMap(stateMap, topState, transition->getStartState());
			impl->insertStateMap(stateMap, topState, transition->getEndState());
			Phrase(transition->getPhrase()).addTransition(
				impl->grammar_, stateMap.find(transition->getStartState())->second, stateMap.find(transition->getEndState())->second);
		}

		// @Lɂ
		if (FAILED(impl->lastResult_ = impl->grammar_->Commit(NULL)) ||
			FAILED(impl->lastResult_ = impl->grammar_->SetGrammarState(SPGS_ENABLED)) ||
			FAILED(impl->lastResult_ = impl->grammar_->SetRuleState(NULL, NULL, SPRS_ACTIVE))) {
			throw domain_error("@̗LɎs܂B");
		}
	}

	GrammarPtr SAPIEngine::getGrammar(const std::string& name) {
		GrammarMap::const_iterator i = impl->grammarMap_.find(name);
		if (i != impl->grammarMap_.end()) {
			return i->second;
		} else {
			return GrammarPtr();
		}
	}

	GrammarPtr SAPIEngine::removeGrammar(const std::string& name) {
		GrammarMap::const_iterator i = impl->grammarMap_.find(name);
		if (i != impl->grammarMap_.end()) {
			// ꎞIɕ@𖳌ɂ
			if (FAILED(impl->lastResult_ = impl->grammar_->SetGrammarState(SPGS_DISABLED))) {
				throw domain_error("@̗LɎs܂B");
			}

			SPSTATEHANDLE targetRule;
			if (FAILED(impl->lastResult_ = impl->grammar_->GetRule(Char2WChar(name), 0, 0, FALSE, &targetRule))) {
				throw domain_error("@̎擾Ɏs܂B");
			}

			if (FAILED(impl->lastResult_ =impl->grammar_->ClearRule(targetRule))) {
				throw domain_error("@̍폜Ɏs܂B");
			}

			// @Lɂ
			if (FAILED(impl->lastResult_ = impl->grammar_->Commit(NULL)) ||
				FAILED(impl->lastResult_ = impl->grammar_->SetGrammarState(SPGS_ENABLED)) ||
				FAILED(impl->lastResult_ = impl->grammar_->SetRuleState(NULL, NULL, SPRS_ACTIVE))) {
				throw domain_error("@̖Ɏs܂B");
			}

			GrammarPtr result = i->second;

			impl->grammarMap_.erase(i);

			return result;
		} else {
			return GrammarPtr();
		}
	}

	void SAPIEngine::clearGrammar() {
		while (impl->grammarMap_.begin() != impl->grammarMap_.end()) {
			removeGrammar(impl->grammarMap_.begin()->first);
		}
	}

	void SAPIEngine_i::insertStateMap(StateMap& stateMap, SPSTATEHANDLE topState, const std::string& stateName) {
		if (stateMap.find(stateName) == stateMap.end()) {
			if (stateName == Grammar::FINISH_STATE_NAME) {
				stateMap[stateName] = (SPSTATEHANDLE) 0;
			} else {
				SPSTATEHANDLE newState;
				if (FAILED(lastResult_ = grammar_->CreateNewState(topState, &newState))) {
					throw domain_error("@̏ԒǉɎs܂B");
				}
				stateMap[stateName] = newState;
			}
		}
	}

	HRESULT STDMETHODCALLTYPE SAPIEngine_i::NotifyCallback(WPARAM wParam, LPARAM lParam) {
		USES_CONVERSION;

		// SĂ̔Fʂ
		CSpEvent event;
		while (event.GetFrom(context_) == S_OK) {
			switch (event.eEventId) {
			case SPEI_RECOGNITION:
				lastResult_ = recognized(event);
				break;
			case SPEI_SOUND_START:
				lastResult_ = soundStarted(event);
				break;
			case SPEI_SOUND_END:
				lastResult_ = soundStoped(event);
				break;
			}
		}  // while

		return S_OK;
	}

	HRESULT SAPIEngine_i::recognized(CSpEvent& event) {
		SAPIRecognition recognition(event);
		self_.getController().recognized(recognition);
		return S_OK;
	}

	HRESULT SAPIEngine_i::soundStarted(CSpEvent& event) {
		self_.getController().soundStarted();
		return S_OK;
	}

	HRESULT SAPIEngine_i::soundStoped(CSpEvent& event) {
		self_.getController().soundStoped();
		return S_OK;
	}

}  // namespace spcf
