/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: Phrase.cpp 67 2011-05-22 06:19:03Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifdef _MSC_VER
#pragma warning(disable:4996)
#endif

#include "spcf/sapi/utils/Phrase.hpp"

#include "spcf/core/GrammarPhrase.hpp"
#include "spcf/sapi/utils/Char2WChar.hpp"
#include "spcf/sapi/utils/PhraseProperty.hpp"

#include <cstring>

using namespace boost;
using namespace std;

namespace spcf {

	class Phrase_i {
	public:
		string phrase_;
		PhrasePropertyPtr property_;

	public:
		Phrase_i(const GrammarPhrasePtr& phrase);
	};

	Phrase::Phrase(const GrammarPhrasePtr& phrase) : impl(new Phrase_i(phrase)) {
	}

	Phrase::~Phrase() {
		delete impl;
	}

	const string& Phrase::getPhrase() const {
		return impl->phrase_;
	}

	const PhrasePropertyPtr& Phrase::getProperty() const {
		return impl->property_;
	}

	HRESULT Phrase::addTransition (
	    const CComPtr<ISpRecoGrammar>& grammar, SPSTATEHANDLE fromState, SPSTATEHANDLE toState) const {
		HRESULT result;

		SPPROPERTYINFO property;
		memset((void*)&property, 0, sizeof(SPPROPERTYINFO));

		Char2WChar nameBuffer;
		VARIANT valBuffer;
		Char2WChar valstrBuffer;
		if (impl->property_) {
			nameBuffer = impl->property_->getName();
			property.pszName = nameBuffer;

			if (impl->property_->hasVal()) {
				VariantInit(&valBuffer);
				V_VT(&valBuffer) = VT_I4;
				V_I4(&valBuffer) = impl->property_->getVal();
				property.vValue = valBuffer;
			}

			if (impl->property_->hasValStr()) {
				valstrBuffer = impl->property_->getValStr();
				property.pszValue = valstrBuffer;
			}
		}

		if (FAILED(result = grammar->AddWordTransition(
		         fromState, toState, Char2WChar(impl->phrase_), NULL, SPWT_LEXICAL, 1,
		         (impl->property_) ? &property : 0))) {
			return result;
		}

		if (impl->property_ && impl->property_->hasVal()) {
			VariantClear(&valBuffer);
		}

		return S_OK;
	}



	Phrase_i::Phrase_i(const GrammarPhrasePtr& phrase) :
	phrase_(phrase->getPhrase()) {
		if (phrase->hasProperty()) {
			if (phrase->hasPropertyInt() && phrase->hasPropertyString()) {
				property_ = PhrasePropertyPtr(new PhraseProperty(phrase->getPropertyName(), phrase->getPropertyInt(), phrase->getPropertyString()));
			} else if (phrase->hasPropertyInt()) {
				property_ = PhrasePropertyPtr(new PhraseProperty(phrase->getPropertyName(), phrase->getPropertyInt()));
			} else if (phrase->hasPropertyString()) {
				property_ = PhrasePropertyPtr(new PhraseProperty(phrase->getPropertyName(), phrase->getPropertyString()));
			} else {
				property_ = PhrasePropertyPtr(new PhraseProperty(phrase->getPropertyName()));
			}
		}
	}

}  // namespace spcf
