# -*- mode: perl; coding: utf-8 -*-
# $Id: 02_SessionManager.t,v 1.3 2009-01-01 02:34:32 morimoto Exp $
# $Source: /home/ishikawa/tmp/TEST/CVS/keitairc/t/02_SessionManager.t,v $
# Copyright (c) 2003-2008 Jun Morimoto <morimoto@mrmt.net>
# This program is covered by the GNU General Public License 2
use strict;
use warnings;
use Test::More tests => 32;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN{
	use_ok('Keitairc::SessionManager');
}

# dh() is not class method
can_ok('Keitairc::SessionManager',
       qw/new verify search_by_session_id search_by_serial_key refresh
	add garbage_collect delete normalize_user_agent/);

# every serial strings are fictitious
my $foma_ua = 'DoCoMo/2.0 P703imyu(c100;TB;W30H15)';
my $foma_ua_icc = 'DoCoMo/2.0 P703imyu(c100;TB;W30H15;ser123498761234567;icc9876543210234567890F)';
my $foma_icc = 'icc9876543210234567890F';

my $softbank_ua_serial = 'SoftBank/1.0/913SH/SHJ001/SN123456789012345 Browser/NetFront/3.4 Profile/MIDP-2.0 Configuration/CLDC-1.1';
my $softbank_serial = 'SN123456789012345';
my $softbank_ua = 'SoftBank/1.0/913SH/SHJ001/ Browser/NetFront/3.4 Profile/MIDP-2.0 Configuration/CLDC-1.1';

use Keitairc::Log;

{
	# create new session manager
	my $sm = new Keitairc::SessionManager;
	ok($sm, 'SessionManager created');
}

{
	# create new session manager /w default_ttl
	my $sm = new Keitairc::SessionManager({default_ttl => 3});
	ok($sm->{default_ttl} == 3, 'SessionManager created with default ttl');
}

my $sm = new Keitairc::SessionManager;
my $s1;

{
	# add new session to session manager (NTT DoCoMo FOMA)
	my $s = $sm->add($foma_ua);
	ok($s, 'new session added');
	ok($s->{last_access_time}, 'session has last_access_time');
	ok(! defined $s->{serial_key}, 'session does not have serial_key');
	ok($s->{user_agent} eq $foma_ua, 'session has user agent');
	ok($s->{ttl}, 'session has ttl');
	ok($s->{id} =~ /S[a-zA-Z]{10}/, 'session has valid session_id');
	$s1 = $s->{id};
}

my $s2;
my $timestamp2;

{
	# add new session to session manager (NTT DoCoMo FOMA /w ser/icc)
	my $s = $sm->add($foma_ua_icc, $foma_icc);
	ok($s, 'new session added');
	ok($s->{last_access_time}, 'session has last_access_time');
	ok($s->{serial_key} eq $foma_icc, 'session has serial_key');
	ok($s->{user_agent} eq $foma_ua, 'session has user agent (serial removed)');
	ok($s->{ttl}, 'session has ttl');
	ok($s->{id} =~ /S[a-zA-Z]{10}/, 'session has valid session_id');
	$s2 = $s->{id};
	$timestamp2 = $s->{last_access_time};
}

my $s3;

{
	# add new session to session manager (SoftBank)
	my $s = $sm->add($softbank_ua_serial, $softbank_serial);
	ok($s, 'new session added');
	ok($s->{last_access_time}, 'session has last_access_time');
	ok($s->{serial_key} eq $softbank_serial, 'session has serial_key');
	ok($s->{user_agent} eq $softbank_ua, 'session has user agent (serial removed)');
	ok($s->{ttl}, 'session has ttl');
	ok($s->{id} =~ /S[a-zA-Z]{10}/, 'session has valid session_id');
	$s3 = $s->{id};
}

my $sid1;
my $sid2;
my $sid3;

{
	my $s;
	$s = $sm->search_by_session_id($s1, $foma_ua);
	ok($s, 'search_by_session_id');
	$sid1 = $s->{id};
	$s = $sm->search_by_session_id($s2, $foma_ua);
	ok($s, 'search_by_session_id');
	$sid2 = $s->{id};
	$s = $sm->search_by_session_id($s3, $softbank_ua);
	ok($s, 'search_by_session_id');
	$sid3 = $s->{id};
}

{
	my $s;
	$s = $sm->search_by_serial_key($foma_icc, $foma_ua);
	ok($s->{id} eq $sid2, 'search_by_serial_key');
	$s = $sm->search_by_serial_key($softbank_serial, $softbank_ua);
	ok($s->{id} eq $sid3, 'search_by_serial_key');
}

{
	my $s;
	$s = $sm->delete($sid1);
	$s = $sm->search_by_session_id($sid1, $foma_ua);
	ok(! defined $s, 'deleted session has vanished');
}

{
	my $s;
	sleep(1);		# timestamp should be incremented
	$s = $sm->verify({session_id => $sid2, user_agent => $foma_ua});
	ok($s, 'verify()');
	ok($timestamp2 < $s->{last_access_time}, 'verify() refreshed timestamp');

	$s = $sm->verify({session_id => $sid2, user_agent => $softbank_ua});
	ok(! defined $s, 'verify() reasonably failed');

	$s = $sm->verify({session_id => $sid1, user_agent => $foma_ua});
	ok(! defined $s, 'verify() reasonably failed');
}

exit;
