#include "../../baygui.h"

namespace baygui {
    namespace awt {
        /** VXN[Xg쐬܂B*/
        Listbox::Listbox() {
            addClassName(baygui_awt_Listbox);
            this->items = new ArrayList();
            this->selectedIndex = 0;
            this->background = Color::white;
        }

        /** fXgN^łB*/
        Listbox::~Listbox() {
            delete this->items;
        }

        /** w肳ꂽڂXN[Xg̏Iɒǉ܂B*/
        void Listbox::add(const char* item) {
            this->items->add(new String(item));
        }

        /** w肷CfbNXɑΉ鍀ڂԂ܂B*/
        char* Listbox::getItem(int index) {
            String* str = (String *) this->items->get(index);
            if (str != NULL) {
                return str->toCharArray();
            } else {
                return NULL;
            }
        }

        /** XgőIĂ鍀ڂ̃CfbNXԂ܂B*/
        int Listbox::getSelectedIndex() {
            return selectedIndex;
        }

        /** Xg̍ڂ̐Ԃ܂B*/
        int Listbox::getItemCount() {
            return this->items->size();
        }

        /** ̃R|[lgyCg܂B*/
        void Listbox::paint(Graphics* g)
        {
            int w = getWidth();
            int h = getHeight();
            int visibleRows = (h - 2) / 16;

            // Og
            if (hasFocus() == true && isEnabled() == true) {
                g->setColor(0,128,255);
                g->drawRect(0, 0, w, h);
            } else {
                g->setColor(getParent()->getBackground());
                g->drawRect(0, 0, w, h);
            }

            // g
            g->setColor(getBackground());
            g->fillRect(1, 1, w - 2, h - 2);
            g->setColor(getForeground());
            g->drawRect(1, 1, w - 2, h - 2);

            // 
            int I = this->items->size();
            for (int i = 0; i < visibleRows; i++) {
                if ((0 + i) < I) {
                    if (this->selectedIndex == i && isEnabled() == true) {
                        g->setColor(0, 128, 255);
                        g->fillRect(3, (16 * i) + 3, w - 6, 16);
                        g->setColor(getBackground());
                        g->drawString(getItem(0 + i), 4, (16 * i) + 6);
                    } else {
                        g->setColor(getForeground());
                        g->drawString(getItem(0 + i), 4, (16 * i) + 6);
                    }
                }
            } 
        }

        /** ̃R|[lgŔL[Cxg܂B*/
        void Listbox::processKeyEvent(KeyEvent* e) {
            Component::processKeyEvent(e);

            if (e->getKeyCode() == UP_PRESSED && this->selectedIndex > 0) {
                this->selectedIndex--;
                repaint();
            } else if (e->getKeyCode() == DOWN_PRESSED && this->selectedIndex < this->items->size() - 1) {
                this->selectedIndex++;
                repaint();
            }
        }

        /** ̃R|[lgŔ}EXCxg܂B*/
        void Listbox::processMouseEvent(MouseEvent* e) {
            Component::processMouseEvent(e);

            if (e->getID() == MouseEvent::MOUSE_PRESSED) {
                this->selectedIndex = (e->getY() - 3) / 16;
                repaint();
            }
        }
    }
}
