#ifndef _SYSTEM_SCHEDULER_H_INCLUDED_
#define _SYSTEM_SCHEDULER_H_INCLUDED_

#define MAX_TASKS       256   /* ő^XN */
#define TASK_GDT_0      3     /* TSSGDT̉Ԃ犄蓖Ă̂ */
#define TASK_KERNEL     0     /* J[l^XN̔ԍ */
#define TASK_IDLE       1     /* ACh^XN̔ԍ */
#define TASK_KEYBOARD   2     /* L[{[h^XN̔ԍ */
#define TASK_MOUSE      3     /* }EX^XN̔ԍ */
#define TASK_CONSOLE    4     /* R\[^XN̔ԍ */

/* C̊֐錾 */
extern "C" {
    /* ACh^XN */
    void task_idle(void);

    /* Avs^XN */
    void task_exec(void);

    /* L[{[h^XN */
    void task_keyboard(void);

    /* }EX^XN */
    void task_mouse(void);

    /* R\[^XN */
    void task_console(void);
}

namespace system {
    /* 32rbgTSS */
    class TSS32 {
    public:
        int backlink, esp0, ss0, esp1, ss1, esp2, ss2, cr3;
        int eip, eflags, eax, ecx, edx, ebx, esp, ebp, esi, edi;
        int es, cs, ss, ds, fs, gs;
        int ldtr, iomap;
    };

    class Console;

    /* ^XN */
    class Task {
    public:
        int   id;             /* ^XNID */
        int   selector;       /* GDT̔ԍ */
        bool  enable;         /* tO */
        char  name[16];       /* ^XN */
        TSS32 tss;            /* 32rbgTSS */
        int   ds_base;        /* f[^ZOgJnAhX */
        int   fpu[108 / 4];   /* FPUWX^ */
        List<Message*>* fifo; /* FIFOobt@ */
        Memory*  memory;      /* Avp}l[W */
        Console* console;     /* R\[ */
        SegmentDescriptor ldt[2]; /* [JLqq */
    };

    /* ^XNXPW[ */
    class Scheduler {
    public:
        static Task** task_list;
        static List<Task*>* runq;
        static Task* current;
        static Task* fpu;
        static bool ready;

    public:
        static void  init(void);
        static Task* allocateTask(int eip, const char* name);
        static void  killTask(int id);
        static void  switchTask(void);
    };
}

#endif
