/* OtBbN֌W */

#include "bootpack.h"

unsigned short table_8_565[256];

void Palette::init(void)
{
	SystemInfo *sysinfo = SystemInfo::get_instance();
	static unsigned char table_rgb[16 * 3] = {
		0x00, 0x00, 0x00,	/*  0: */
		0xff, 0x00, 0x00,	/*  1:邢 */
		0x00, 0xff, 0x00,	/*  2:邢 */
		0xff, 0xff, 0x00,	/*  3:邢F */
		0x00, 0x00, 0xff,	/*  4:邢 */
		0xff, 0x00, 0xff,	/*  5:邢 */
		0x00, 0xff, 0xff,	/*  6:邢F */
		0xff, 0xff, 0xff,	/*  7: */
		0xc6, 0xc6, 0xc6,	/*  8:邢DF */
		0x84, 0x00, 0x00,	/*  9:Â */
		0x00, 0x84, 0x00,	/* 10:Â */
		0x84, 0x84, 0x00,	/* 11:ÂF */
		0x00, 0x00, 0x84,	/* 12:Â */
		0x84, 0x00, 0x84,	/* 13:Â */
		0x00, 0x84, 0x84,	/* 14:ÂF */
		0x84, 0x84, 0x84	/* 15:ÂDF */
	};
	int i, r, g, b;
	if (sysinfo->vmode == 8) {
		for (i = 0; i < 16; i++) {
			table_8_565[i] = i;
		}
		Palette::set(0, 15, table_rgb);
		unsigned char table2[216 * 3];
		for (b = 0; b < 6; b++) {
			for (g = 0; g < 6; g++) {
				for (r = 0; r < 6; r++) {
					table2[(r + g * 6 + b * 36) * 3 + 0] = r * 51;
					table2[(r + g * 6 + b * 36) * 3 + 1] = g * 51;
					table2[(r + g * 6 + b * 36) * 3 + 2] = b * 51;
					table_8_565[r + g * 6 + b * 36 + 16] = r + g * 6 + b * 36 + 16;
				}
			}
		}
		Palette::set(16, 231, table2);
	} else {
		for (i = 0; i < 16; i++) {
			r = table_rgb[i * 3 + 0];
			g = table_rgb[i * 3 + 1];
			b = table_rgb[i * 3 + 2];
			table_8_565[i] = (unsigned short) (((r << 8) & 0xf800) |
							 ((g << 3) & 0x07e0) | (b >> 3));
		}
		for (b = 0; b < 6; b++) {
			for (g = 0; g < 6; g++) {
				for (r = 0; r < 6; r++) {
					table_8_565[r + g * 6 + b * 36 + 16] =
						(unsigned short) ((((r * 51) << 8) & 0xf800) |
						(((g * 51) << 3) & 0x07e0) | ((b * 51) >> 3));
				}
			}
		}
	}
	return;
}

void Palette::set(int start, int end, unsigned char *rgb)
{
	int i, eflags;
	eflags = io_load_eflags();	/* 荞݋tO̒lL^ */
	io_cli(); 					/* tO0ɂĊ荞݋֎~ɂ */
	io_out8(0x03c8, start);
	for (i = start; i <= end; i++) {
		io_out8(0x03c9, rgb[0] / 4);
		io_out8(0x03c9, rgb[1] / 4);
		io_out8(0x03c9, rgb[2] / 4);
		rgb += 3;
	}
	io_store_eflags(eflags);	/* 荞݋tOɖ߂ */
	return;
}

void Graphics::fill_rect(unsigned short *vram, int xsize, unsigned char c, int x0, int y0, int x1, int y1)
{
	int x, y;
	for (y = y0; y <= y1; y++) {
		for (x = x0; x <= x1; x++)
			vram[y * xsize + x] = table_8_565[c];
	}
	return;
}

//void Graphics::init(unsigned short *vram, int x, int y)
//{
//	Graphics::fill_rect(vram, x, COL8_008484,  0,     0,      x -  1, y - 29);
//	Graphics::fill_rect(vram, x, COL8_C6C6C6,  0,     y - 28, x -  1, y - 28);
//	Graphics::fill_rect(vram, x, COL8_FFFFFF,  0,     y - 27, x -  1, y - 27);
//	Graphics::fill_rect(vram, x, COL8_C6C6C6,  0,     y - 26, x -  1, y -  1);
//
//	Graphics::fill_rect(vram, x, COL8_FFFFFF,  3,     y - 24, 59,     y - 24);
//	Graphics::fill_rect(vram, x, COL8_FFFFFF,  2,     y - 24,  2,     y -  4);
//	Graphics::fill_rect(vram, x, COL8_848484,  3,     y -  4, 59,     y -  4);
//	Graphics::fill_rect(vram, x, COL8_848484, 59,     y - 23, 59,     y -  5);
//	Graphics::fill_rect(vram, x, COL8_000000,  2,     y -  3, 59,     y -  3);
//	Graphics::fill_rect(vram, x, COL8_000000, 60,     y - 24, 60,     y -  3);
//
//	Graphics::fill_rect(vram, x, COL8_848484, x - 47, y - 24, x -  4, y - 24);
//	Graphics::fill_rect(vram, x, COL8_848484, x - 47, y - 23, x - 47, y -  4);
//	Graphics::fill_rect(vram, x, COL8_FFFFFF, x - 47, y -  3, x -  4, y -  3);
//	Graphics::fill_rect(vram, x, COL8_FFFFFF, x -  3, y - 24, x -  3, y -  3);
//	return;
//}

//void Graphics::draw_char(unsigned short *vram, int xsize, int x, int y, char c, char *font)
//{
//	int i;
//	char d /* data */;
//	unsigned short *p;
//	for (i = 0; i < 16; i++) {
//		p = vram + (y + i) * xsize + x;
//		d = font[i];
//		if ((d & 0x80) != 0) { p[0] = table_8_565[c & 0xff]; }
//		if ((d & 0x40) != 0) { p[1] = table_8_565[c & 0xff]; }
//		if ((d & 0x20) != 0) { p[2] = table_8_565[c & 0xff]; }
//		if ((d & 0x10) != 0) { p[3] = table_8_565[c & 0xff]; }
//		if ((d & 0x08) != 0) { p[4] = table_8_565[c & 0xff]; }
//		if ((d & 0x04) != 0) { p[5] = table_8_565[c & 0xff]; }
//		if ((d & 0x02) != 0) { p[6] = table_8_565[c & 0xff]; }
//		if ((d & 0x01) != 0) { p[7] = table_8_565[c & 0xff]; }
//	}
//	return;
//}

//void Graphics::draw_string(unsigned short *vram, int xsize, int x, int y, char c, char *s)
//{
//	extern char hankaku[4096];
//	Task *task = Task::now();
//	char *nihongo = (char *) *((int *) 0x0fe8), *font;
//	int k, t;
//
//	if (task->langmode == 0) {
//		for (; *s != 0x00; s++) {
//			Graphics::draw_char(vram, xsize, x, y, c, hankaku + *s * 16);
//			x += 8;
//		}
//	}
//	if (task->langmode == 1) {
//		for (; *s != 0x00; s++) {
//			if (task->langbyte1 == 0) {
//				if ((0x81 <= *s && *s <= 0x9f) || (0xe0 <= *s && *s <= 0xfc)) {
//					task->langbyte1 = *s;
//				} else {
//					Graphics::draw_char(vram, xsize, x, y, c, nihongo + *s * 16);
//				}
//			} else {
//				if (0x81 <= task->langbyte1 && task->langbyte1 <= 0x9f) {
//					k = (task->langbyte1 - 0x81) * 2;
//				} else {
//					k = (task->langbyte1 - 0xe0) * 2 + 62;
//				}
//				if (0x40 <= *s && *s <= 0x7e) {
//					t = *s - 0x40;
//				} else if (0x80 <= *s && *s <= 0x9e) {
//					t = *s - 0x80 + 63;
//				} else {
//					t = *s - 0x9f;
//					k++;
//				}
//				task->langbyte1 = 0;
//				font = nihongo + 256 * 16 + (k * 94 + t) * 32;
//				Graphics::draw_char(vram, xsize, x - 8, y, c, font     );	/*  */
//				Graphics::draw_char(vram, xsize, x    , y, c, font + 16);	/* E */
//			}
//			x += 8;
//		}
//	}
//	if (task->langmode == 2) {
//		for (; *s != 0x00; s++) {
//			if (task->langbyte1 == 0) {
//				if (0x81 <= *s && *s <= 0xfe) {
//					task->langbyte1 = *s;
//				} else {
//					Graphics::draw_char(vram, xsize, x, y, c, nihongo + *s * 16);
//				}
//			} else {
//				k = task->langbyte1 - 0xa1;
//				t = *s - 0xa1;
//				task->langbyte1 = 0;
//				font = nihongo + 256 * 16 + (k * 94 + t) * 32;
//				Graphics::draw_char(vram, xsize, x - 8, y, c, font     );	/*  */
//				Graphics::draw_char(vram, xsize, x    , y, c, font + 16);	/* E */
//			}
//			x += 8;
//		}
//	}
//	return;
//}

//void putblock8_8(unsigned short *vram, int vxsize, int pxsize,
//	int pysize, int px0, int py0, unsigned short *buf, int bxsize)
//{
//	int x, y;
//	for (y = 0; y < pysize; y++) {
//		for (x = 0; x < pxsize; x++) {
//			vram[(py0 + y) * vxsize + (px0 + x)] = table_8_565[buf[y * bxsize + x]];
//		}
//	}
//	return;
//}
