package jp.hasc.hasctool.core.data;

/**
 * SignalMessageを実装するためのsuperclassです
 * @author iwasaki
 */
public abstract class AbstractSignalMessage implements SignalMessage {
	private long time_;
	
	public AbstractSignalMessage(long time) {
		super();
		time_ = time;
	}

	@Override
	public long getTime() {
		return time_;
	}
	

	/** auto generated */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (int) (time_ ^ (time_ >>> 32));
		return result;
	}

	/** auto generated */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AbstractSignalMessage other = (AbstractSignalMessage) obj;
		if (time_ != other.time_)
			return false;
		return true;
	}
}
