package jp.hasc.hasctool.core.data;

import java.util.Comparator;

/**
 * VectorSignalMessageを、時刻順に並べるComparatorです。
 * @author iwasaki
 */
public class DefaultVectorSignalComparator implements Comparator<VectorSignalMessage> {

	@Override
	public int compare(VectorSignalMessage lhs, VectorSignalMessage rhs) {
		{
			// 時刻順
			long d=lhs.getTime() - rhs.getTime();
			if (d!=0) return (d>0)?1:-1;
		}
		{
			// ベクトルの辞書順
			int lsize=lhs.getVectorSize(), rsize=rhs.getVectorSize();
			int minsize=Math.min(lsize,rsize);
			for(int i=0;i<minsize;++i) {
				double d=lhs.getVectorElement(i) - rhs.getVectorElement(i);
				if (d!=0) return (d>0)?1:-1;
			}
			return lsize-rsize;
		}
	}
}
