package jp.hasc.hasctool.core.data;

/**
 * VectorSignalMessageのためのユーティリティです
 * @author iwasaki
 */
public class VectorSignalMessages {

	static final double[] NULL_VECTOR_VALUE = new double[]{};

	/**
	 * double配列を元に、VectorSignalMessageを生成します。
	 * サイズ1の場合は、ScalarSignalMessageになります。
	 * vectorValueはclone()されますので、関数呼び出し後、内容を変更してもかまいません。
	 */
	public static VectorSignalMessage create(long time, double[] vectorValue) {
		return VectorSignalMessages.create(time, vectorValue, true);
	}

	/**
	 * double配列を元に、VectorSignalMessageを生成します。
	 * cloneVectorValue=falseとした場合は、関数呼び出し後、vectorValueの内容を変更してはいけません。
	 */
	public static VectorSignalMessage create(long time, double[] vectorValue, boolean cloneVectorValue) {
		if (vectorValue.length==1) return VectorSignalMessages.createScalar(time, vectorValue[0]);
		return new ArrayVectorSignalMessage(time, vectorValue, cloneVectorValue);
	}

	/**
	 * double値を元に、ScalarSignalMessage(サイズ1のVectorSignalMessage)を生成します
	 */
	public static VectorSignalMessage createScalar(long time, double scalarValue) {
		return new ScalarSignalMessage(time, scalarValue);
	}

	/**
	 * サイズ0のVectorSignalMessageを生成します
	 */
	public static VectorSignalMessage createEmpty(long time) {
		return new ArrayVectorSignalMessage(time, NULL_VECTOR_VALUE, false);
	}

}
