package jp.hasc.hasctool.core.runtime;

/**
 * HascToolのブロックを実行するオブジェクトです。
 * <pre>
 * RuntimeBeanの初期化の手順：
 * - デフォルトコンストラクタ の呼び出し
 * - プロパティをセット
 * - setup(RuntimeContext) の呼び出し
 * - Port間をconnect
 * </pre>
 * @author iwasaki
 */
public interface RuntimeBean {
	/**
	 * プロパティをセットした後に呼び出されます。
	 * このメソッドが完了するまでに、Portオブジェクトの準備を完了して下さい。
	 */
	public void setup(RuntimeContext context);
}
