package jp.hasc.hasctool.core.runtime.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * ブロックのクラスにつけるメタデータです
 * @author iwasaki
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface RuntimeBeanInfo {
	/** 入力ポート（複数可）に関する情報です */
	PortInfo[] inputPorts() default {};
	/** 出力ポート（複数可）に関する情報です */
	PortInfo[] outputPorts() default {};
}
