package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.SignalMessage;

/**
 * time値 に delay を加算するフィルタです
 * @author iwasaki
 */
public class DelayFilter extends AbstractFilter {
	private long delay_=0;
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof SignalMessage) {
			SignalMessage se = (SignalMessage)message;
			outputMessage(se.createDelayedElement(delay_));
		}else{
			outputMessage(message);
		}
	}

	public long getDelay() {
		return delay_;
	}

	public void setDelay(long delay) {
		delay_ = delay;
	}
}
