package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;

/**
 * VectorSignalMessageの方向を出力するフィルタです
 * 入力a1,a2,a3.....に対し、arctan(a1/a2),arctan(a2/a3),.....を出力します
 * @author hiro
 */
public class VectorAngleFilter extends AbstractFilter {

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			VectorSignalMessage vsig = (VectorSignalMessage) message;
			// 新しいベクトルの値を計算
			double[] newValue=new double[vsig.getVectorSize()];
			for(int i=0;i<newValue.length;++i){
				int index = (i+1)%newValue.length;
				double val = 0.0;
				if(vsig.getVectorElement(index) != 0.0){
					val = vsig.getVectorElement(i)/vsig.getVectorElement(index);
				}
				newValue[i] = Math.atan(val);
			}
			// output
			outputMessage(VectorSignalMessages.create(vsig.getTime(), newValue));
		}else{
			outputMessage(message);
		}
	}
}
