package jp.hasc.hasctool.core.runtime.filter.evaluation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.util.CoreUtil;


/**
 *　評価結果ファイルをまとめます
 * @author hiro
 */
public class EvaluationMerger extends AbstractFilter{

	String element_;
	String[] eList_;
	int eleNum_;
	EvaluationData evalData_;
	HashMap<String, Double> hmap_;
	HashMap<String, Double> allmap_;

	public void setElement(String element){
		element_= element;
	}

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		this.start();
	}

	private void start(){
		hmap_ = new HashMap<String, Double>();
		allmap_ = new HashMap<String, Double>();
		evalData_ = new EvaluationData(element_);
		eList_ = element_.split(",");
		eleNum_ = eList_.length;
		for(int i=0; i<eleNum_; i++){
			allmap_.put(eList_[i], 0.0);
		}
	}

	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String filePath =(String)message;
			int count = 0;
			boolean start = true;
			try{
				InputStream inps = getRuntimeContext().getFileStreamProvider().openInputStream(filePath);
				BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inps, RuntimeContext.DEFAULT_CHARSET));
				for(int i=0; i<eleNum_; i++){
					String line = bufferedReader.readLine();
					String[] row = line.split(",");
					hmap_.put(row[0], Double.parseDouble(row[1]));
				}

				while(true){
					String line = bufferedReader.readLine();
					if (line == null) {
						break;

					} else {
						if(start){
							start = false;
						} else {
							String[] row = line.split(",");
							int len = row.length;

							if(len-1 == evalData_.getElementNum()){
								double time = hmap_.get(row[0]);
								for(int i=1; i<len; i++){
									int index = i-1;
									evalData_.setData(Double.parseDouble(row[i])*time, count, index);
								}
								count++;
							}
						}
					}
				}
				for(int i=0; i<eleNum_; i++){
					double alltime = allmap_.get(eList_[i]);
					alltime += hmap_.get(eList_[i]);
					allmap_.put(eList_[i], alltime);
				}
				bufferedReader.close();
				inps.close();
			} catch (IOException ex) {
				CoreUtil.throwAsRuntimeException(ex);
			} catch (RuntimeException ex) {
			}

		} else if (message == EnumCommand.END) {
			for(int i=0; i<eleNum_; i++){
				double alltime = allmap_.get(eList_[i]);
				evalData_.div(alltime,i);
			}
			String[][] evalTable = evalData_.getData();
			int len = evalTable[0].length;
			outputMessage(EnumCommand.BEGIN);
			for(int i=0; i<len; i++){
				String row = evalTable[i][0];
				for(int j=1; j<len; j++){
					row += "," + evalTable[i][j];
				}
				outputMessage(row);
			}
			outputMessage("Overall," + evalData_.getOverAll());
			outputMessage(EnumCommand.END);

		} else {
			// その他のメッセージ（BEGIN）はそのまま出力
			outputMessage(message);
		}
	}
}
