package jp.hasc.hasctool.core.runtime.filter.file.message;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * messageに指定した文字が含まれる場合のみ出力します
 * @author hiro
 */
public class MessageSelector extends AbstractFilter{

	private String val_ = null;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			if (0 <= s.indexOf(val_)){
				outputMessage(s);
			}
		}else{
			//BEGIN,END message
			outputMessage(message);
		}
	}
	
	public void setMessage(String val){
		val_ = val;
	}
}
