package jp.hasc.hasctool.core.runtime.filter.file.table;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * テーブルを対象としたカウントクラス(abstract class)
 * @author hiro
 */

public abstract class TableCounter extends AbstractFilter{

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			count(s);
		} else if (message == EnumCommand.END) {
			String inf = getResult();
			outputMessage(inf);
			outputMessage(message);
		} else {
			//BEGIN message
			outputMessage(message);
		}
	}

	abstract void count(String line);

	abstract String getResult();

}
