package jp.hasc.hasctool.core.runtime.filter.interpolator;

import jp.hasc.hasctool.core.data.NullSignalMessage;
import jp.hasc.hasctool.core.data.SignalMessage;

/**
 * 直前（同時刻含む）のSignalMessageを、timeのみ変更して返すSignalInterpolatorです
 * @author iwasaki
 */
public class LastMessageInterpolator implements SignalInterpolator {
	
	private SignalMessage previous_=null, next_=null;

	@Override
	public boolean addSample(SignalMessage message) {
		previous_=next_;
		next_=message;
		return true;
	}

	@Override
	public SignalMessage getAtTime(long time) {
		SignalMessage tgt=null;
		tgt=(next_!=null && next_.getTime()<=time) ? next_ : previous_;
		if (tgt==null) return new NullSignalMessage(time);
		//return tgt;
		return tgt.createDelayedElement(time-tgt.getTime());
	}

}
