package jp.hasc.hasctool.core.runtime.filter.window;

/**
 * AbstractFilterを使ったフィルタ
 * ベクトルの各要素に対してBlackman窓を適用する
 * @author hiro
 */
public class BlackmanWindowFunctionFilter extends AbstractWindowFunctionFilter {

	public double[] windowFunction(double[] input, int index){
		int N = input.length;
		double[] newValue = new double[N];
		for(int n=0; n<N; n++){
			int m = (n+index)%N;
			double val = 0.42 - 0.5*Math.cos( 2.0*Math.PI*n/(N-1) ) + 0.08*Math.cos( 4.0*Math.PI*n/(N-1) );
			newValue[n] = input[m] * val;
		}
		return newValue;
	}

}
