package jp.hasc.hasctool.core.runtime.script;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.source.AbstractSource;

/**
 * 外部のScriptファイルを実行できる、１出力Sourceです。
 * @author iwasaki
 */
public class ScriptSource extends AbstractSource {

	private String scriptLanguage_ = ScriptSupport.LANGUAGE_JAVASCRIPT;
	private ScriptSupport scriptSupport_;
	private String scriptPath_;
	
	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		//
		scriptSupport_=new ScriptSupport(scriptLanguage_);
		scriptSupport_.setup(this,scriptPath_);
	}
	
	public void setScriptLanguage(String language) {
		scriptLanguage_ = language;
	}
	
	public void setScriptPath(String filePath) {
		scriptPath_=filePath;
	}
	
	//
	@Override
	protected void run() throws InterruptedException {
		scriptSupport_.invokeFunction("run");
	}
	
	@Override
	public void outputMessage(Object message) throws InterruptedException {
		super.outputMessage(message);
	}
}
