package jp.hasc.hasctool.ui.views;

import jp.hasc.hasctool.core.data.LabelSignalMessage;
import jp.hasc.hasctool.core.data.ObjectSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.runtime.annotation.PortInfo;
import jp.hasc.hasctool.core.runtime.annotation.RuntimeBeanInfo;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/**
 * WaveViewにデータを転送するBean
 * @author iwasaki
 */
@RuntimeBeanInfo(
		inputPorts = { @PortInfo(name = "inputPort", classes = {VectorSignalMessage.class, LabelSignalMessage.class, ObjectSignalMessage.class, String.class}) }
)
public class RuntimeWaveView extends AbstractRuntimeWaveView {
	private WaveView waveView_;
	
	protected void setupView(IWorkbenchWindow window, String keyName) throws Exception {
		waveView_=(WaveView) window.getActivePage().showView(WaveView.ID
				,keyName, IWorkbenchPage.VIEW_VISIBLE);
		WaveViewWidget waveViewWidget = waveView_.getWaveViewWidget();
		waveViewWidget.setTitleName(keyName);
		waveViewWidget.setValueMin(getMinValue());
		waveViewWidget.setValueHeight(getMaxValue()-getMinValue());
	}
	
	public MessageProcessor getInputPort() {
		return waveView_.getInputPort();
	}
}
