/**
 * 
 */
package jp.hasc.hasctool.ui.views.grapheditor;


import java.util.ArrayList;
import java.util.HashMap;

import jp.hasc.hasctool.core.blockdiagram.model.AbstractBlock;
import jp.hasc.hasctool.core.blockdiagram.model.BeanBlock;
import jp.hasc.hasctool.core.blockdiagram.model.BlockDiagram;
import jp.hasc.hasctool.core.blockdiagram.model.Connection;
import jp.hasc.hasctool.core.util.Pair;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.zest.core.viewers.IGraphEntityRelationshipContentProvider;

/**
 * @author Nobuo Kawaguchi, iwasaki
 */
public class BlockDiagramContentProvider  implements
	IGraphEntityRelationshipContentProvider {
	private BlockDiagramGraphWidget bdg_;
	private BlockDiagram bd_;
	private HashMap <String, IBlockObject> blockObjMap_;
	private HashMap <Pair<String,String>, ArrayList<ConnectionObject>> connectionsMap_;
	//public BlockDiagramSelectionChangedListener selListener_;

	
	public BlockDiagramContentProvider(BlockDiagramGraphWidget bdg/*BlockDiagram bd*/) {
		/*
		bd_ = bd;
		blockNames_ = new HashMap<String,AbstractBlock>();
		for(AbstractBlock b : bd_.getBlocks()) {
			blockNames_.put(b.getName(), b);
		}
		*/
		bdg_=bdg;
		
		//selListener_ = new BlockDiagramSelectionChangedListener();
	}

	/*
	private IBlockObject getBlock(PortReference pr) {
		IBlockObject b = blockObjMap_.get(pr.getBlockName());
		return b;
	}
	
	
	@Override
	public Object getDestination(Object rel) {
		if( rel instanceof ConnectionObject){
			Connection c = ((ConnectionObject)rel).getConnection();
			return getBlock(c.getInputPortReference());
		}		
		return null;
	}
	@Override
	public Object getSource(Object rel) {
		if( rel instanceof ConnectionObject){
			Connection c = ((ConnectionObject)rel).getConnection();
			return getBlock(c.getOutputPortReference());
		}		
		return null;
	}
*/

	@Override
	public Object[] getElements(Object input) {
		ArrayList<Object> al = new ArrayList<Object>();
		if( input instanceof BlockDiagram ){ // 
			bd_ = (BlockDiagram)input;
			blockObjMap_ = new HashMap<String,IBlockObject>();
			for(AbstractBlock b : bd_.getBlocks()) {
				if (b instanceof BeanBlock) {
					BeanBlockObject bbo = new BeanBlockObject(bdg_, (BeanBlock)b);
					blockObjMap_.put(b.getName(), bbo);
					al.add(bbo);
				}else{
					throw new RuntimeException("not supported: "+b.getClass());
				}
			}
			connectionsMap_=new HashMap<Pair<String,String>, ArrayList<ConnectionObject>>();
			for (Connection c : bd_.getConnections()) {
				Pair<String,String> sdn = new Pair<String,String>(c.getOutputPortReference().getBlockName(),
						c.getInputPortReference().getBlockName());
				ArrayList<ConnectionObject> m = connectionsMap_.get(sdn);
				if (m==null) {
					m=new ArrayList<ConnectionObject>();
					connectionsMap_.put(sdn, m);
				}
				m.add(new ConnectionObject(bdg_,c));
			}
			return al.toArray();
		}
		return null;
	}


	@Override
	public void dispose() {
	}
	@Override
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		
	}

	/*		// for SelectionChangedListener
	class BlockDiagramSelectionChangedListener implements
	ISelectionChangedListener {

		@Override
		public void selectionChanged(SelectionChangedEvent e) {// click されると。。
			// IPropertyPorvider で解決
		IStructuredSelection sel 
			= (IStructuredSelection)e.getSelection();
			Object [] objs = sel.toArray();
			for (int i=0; i<objs.length; i++){
//				System.out.println("Obj: "+objs[i]);
//				Person p = (Person)objs[i];
//				System.out.println(p.name + " が選択されました。");
				Object ob = objs[i];
				if( ob instanceof BeanBlock ){
					BeanBlock bb = (BeanBlock)ob;
					bb.getName();
				}else if (ob instanceof Connection){
					Connection co = (Connection)ob;
					
				}else {
					System.out.println("Unknown Object "+ob);
				}
			}
	
		}
		
	}
				*/

	public HashMap<String, IBlockObject> getBlockObjMap() {
		return blockObjMap_;
	}

	@Override
	public Object[] getRelationships(Object source, Object dest) {
		Pair<String,String> sdn = new Pair<String,String>(((IBlockObject)source).getBlock().getName(),
				((IBlockObject)dest).getBlock().getName());
		ArrayList<ConnectionObject> m = connectionsMap_.get(sdn);
		if (m==null) return null;
		return m.toArray();
	}
	
	
}
