// based on GEF ShapesEditor example
/*******************************************************************************
 * Copyright (c) 2004, 2005 Elias Volanakis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Elias Volanakis - initial API and implementation
 *******************************************************************************/
package jp.hasc.hasctool.ui.bdeditor2;

import jp.hasc.hasctool.ui.bdeditor2.model.BlockElement;
import jp.hasc.hasctool.ui.bdeditor2.model.CommentElement;
import jp.hasc.hasctool.ui.bdeditor2.model.ConnectionElement;

import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * @author iwasaki
 */
final class BlockDiagramEditorPaletteFactory {
	
	/**
	 * Creates the PaletteRoot and adds all palette elements. Use this factory
	 * method to create a new palette for your graphical editor.
	 * 
	 * @return a new PaletteRoot
	 */
	static PaletteRoot createPalette() {
		PaletteRoot palette = new PaletteRoot();
		palette.add(createToolsGroup(palette));
		return palette;
	}

	/** Create the "Tools" group. */
	private static PaletteContainer createToolsGroup(PaletteRoot palette) {
		PaletteGroup toolbar = new PaletteGroup("Tools");

		// Add a selection tool to the group
		ToolEntry tool = new PanningSelectionToolEntry();
		toolbar.add(tool);
		palette.setDefaultEntry(tool);
		
		// Add block tool
		tool = new CombinedTemplateCreationEntry("Block",
				"Create a block", BlockElement.class, new SimpleFactory(
						BlockElement.class), ImageDescriptor.createFromFile(
						BlockDiagramEditorUtil.class, "icons/block16.gif"),
				ImageDescriptor.createFromFile(BlockDiagramEditorUtil.class,
						"icons/rectangle16.gif"));
		tool.setToolProperty(AbstractTool.PROPERTY_UNLOAD_WHEN_FINISHED, Boolean.TRUE);
		toolbar.add(tool);
		
		// Add comment tool
		tool = new CombinedTemplateCreationEntry("Comment",
				"Create a comment", CommentElement.class, new SimpleFactory(
						CommentElement.class), ImageDescriptor.createFromFile(
						BlockDiagramEditorUtil.class, "icons/comment16.gif"),
				ImageDescriptor.createFromFile(BlockDiagramEditorUtil.class,
						"icons/rectangle16.gif"));
		tool.setToolProperty(AbstractTool.PROPERTY_UNLOAD_WHEN_FINISHED, Boolean.TRUE);
		toolbar.add(tool);
		
		// Add connection tool
		tool = new ConnectionCreationToolEntry("Connection",
				"Create a connection", new SimpleFactory(
						ConnectionElement.class), ImageDescriptor.createFromFile(
						BlockDiagramEditorUtil.class, "icons/connection_s16.gif"),
				ImageDescriptor.createFromFile(BlockDiagramEditorUtil.class,
						"icons/connection_s16.gif"));
		tool.setToolProperty(AbstractTool.PROPERTY_UNLOAD_WHEN_FINISHED, Boolean.FALSE);
		toolbar.add(tool);
		
		return toolbar;
	}
}