// based on GEF ShapesEditor example
/*******************************************************************************
 * Copyright (c) 2004, 2005 Elias Volanakis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Elias Volanakis - initial API and implementation
 *******************************************************************************/
package jp.hasc.hasctool.ui.bdeditor2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

import org.eclipse.swt.graphics.Image;

/**
 * @author iwasaki
 */
public class BlockDiagramEditorUtil {

	public static Image createImage(String name) {
		InputStream stream = BlockDiagramEditorUtil.class.getResourceAsStream(name);
		Image image = new Image(null, stream);
		try {
			stream.close();
		} catch (IOException ioe) {
		}
		return image;
	}

	public static <T> boolean removeElement(Iterable<T> list,T target, boolean onlyFirst) {
		boolean found=false;
		for(Iterator<T> it = list.iterator();it.hasNext();) {
			T c2 = it.next();
			if (c2==target) {
				// found
				it.remove();
				found=true;
				if (onlyFirst) break;
			}
		}
		return found;
	}

}