package jp.hasc.hasctool.core.runtime.filter.weka;

import weka.core.Instance;

/**
 * weka ライブラリを利用して識別を行うフィルタです
 * output : time,label
 * @author hiro
 */

public class EvaluationTimeFilter extends EvaluationFilter {

	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof WekaDataInstance) {
			wdi_ = (WekaDataInstance)message;
			learningDataset_ = wdi_.getLearningDataset();
			predictiveModel_ = wdi_.getPredictiveModel();

		} else if (message instanceof String) {
			try {
				String s = (String)message;
				String[] data = s.split(",");
				int len = data.length;
				String time = data[0];
				String[] val = new String[len];
				for(int i = 0; i<len-1; i++){
					val[i] = data[i+1];
				}
				val[len-1] = eList_[0];
				Instance perdictInstance = createInstance(learningDataset_, val);
				double prediction = predictiveModel_.classifyInstance(perdictInstance);
				predictElement_ = perdictInstance.classAttribute().value((int) prediction); 
				outputMessage(time + "," + predictElement_);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
				} else {
			// その他のメッセージはそのまま出力(BEGIN,ENDを含む)
			outputMessage(message);
		}
	}
}
