package jp.hasc.hasctool.core.runtime.filter.weka.file;

import java.util.ArrayList;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 評価結果ファイルを作成するフィルタです
 * @author hiro
 */
public class EvaluationFileCreator extends AbstractFilter{

	ArrayList<String> timeInf_;
	String labelLine_;
	String filePath_;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		timeInf_ = new ArrayList<String>();	
	}

	public void setLabelLine(String labelLine) {
		labelLine_ = labelLine;
	}
	
	public void setFilePath(String filePath) {
		filePath_ = filePath;
	}
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String line =(String)message;
			String[] val = line.split(",");
			timeInf_.add(val[0]);
			
		} else if (message == EnumCommand.BEGIN) {
			outputMessage(EnumCommand.BEGIN);
			outputMessage("#targetfile:"+filePath_);
			
		} else if (message == EnumCommand.END) {
			String[] label = labelLine_.split(",");
			int len = label.length;
			for(int i=0; i<len-1; i++){

				outputMessage(timeInf_.get(i) 
						+ "," + timeInf_.get(i+1) 
						+ "," + label[i]);
			}
			double ptime = Double.parseDouble(timeInf_.get(len-2));	
			double ctime = Double.parseDouble(timeInf_.get(len-1));
			double ntime = ctime + (ctime - ptime);

			outputMessage(ctime + "," + ntime 
					+ "," + label[len-1]); 

			outputMessage(EnumCommand.END);

		}else{
			outputMessage(message);
		}
	}
}
