package jp.hasc.hasctool.core.runtime.filter.weka.learning;

import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instances;
import jp.hasc.hasctool.core.runtime.RuntimeContext;

/**
 * 機械学習にClassifierを使用します
 * @author hiro
 */

public abstract class LearningClassifier extends MachineLearning {

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}

	//予測モデルの作成＆評価を行うメソッド
	void evaluatepredictiveModel(){
		try {
			Classifier predictiveModel = learnPredictiveModel(learningDataset_);		
			System.out.println("START EVALUATION");
			Evaluation evaluation = evaluatePredictiveModel(predictiveModel,  learningDataset_);
			System.out.println(evaluation.toSummaryString());
			wdi_.setLearningDataset(learningDataset_);
			wdi_.setPredictiveModel(predictiveModel);

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	//予測モデル作成メソッド
	private Classifier learnPredictiveModel(Instances learningDataset) throws Exception {
		Classifier classifier = getClassifier();
		classifier.buildClassifier(learningDataset);
		return classifier;
	}

	//使用分類器の作成メソッド
	abstract Classifier getClassifier();

	//学習結果から生成されたモデルの評価を行うメソッド
	private Evaluation evaluatePredictiveModel(
			Classifier classifier, Instances learningDataset) throws Exception {
		Evaluation learningSetEvaluation = new Evaluation(learningDataset);
		learningSetEvaluation.evaluateModel(classifier, learningDataset);
		return learningSetEvaluation;
	}
}
