package jp.hasc.hasctool.core.blockdiagram.model;

import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

/**
 * @author iwasaki
 */
public class PortReference extends AbstractModel {

	private static final long serialVersionUID = 1L;

	public static final String INPUT_PORT = "inputPort";
	public static final String OUTPUT_PORT = "outputPort";
	public static final String INPUT_PORTS_NUM = "inputPortsNum";
	public static final String OUTPUT_PORTS_NUM = "outputPortsNum";
	
	@XStreamAsAttribute
	private String blockName;
	
	@XStreamAsAttribute
	private String portName;
	
	public PortReference(String blockName, String portName) {
		this.blockName=blockName;
		this.portName=portName;
	}

	public String getBlockName() {
		return blockName;
	}

	public String getPortName() {
		return portName;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result
				+ ((blockName == null) ? 0 : blockName.hashCode());
		result = prime * result
				+ ((portName == null) ? 0 : portName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		PortReference other = (PortReference) obj;
		if (blockName == null) {
			if (other.blockName != null)
				return false;
		} else if (!blockName.equals(other.blockName))
			return false;
		if (portName == null) {
			if (other.portName != null)
				return false;
		} else if (!portName.equals(other.portName))
			return false;
		return true;
	}
	
	
}
