package jp.hasc.hasctool.core.data;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * ラベルの情報です。
 * ラベルを出力したい場合、ラベルごとに新規LabelInfoを生成し、createBeginMessage(),createEndMessage()で生成したメッセージを、時間順に出力して下さい。
 * @author iwasaki
 */
public class LabelInfo implements Comparable<LabelInfo> {
	private String label_;
	private int id_;
	protected static AtomicInteger idCounter_=new AtomicInteger();
	public static final String HEADER_PREFIX_TARGET_FILE = "#targetfile:";
	
	public LabelInfo(String label) {
		super();
		label_ = label;
		id_ = idCounter_.incrementAndGet();
	}

	public LabelSignalMessage createBeginMessage(long time) {
		return new LabelSignalMessage(time, LabelSignalMessage.Type.BEGIN, this);
	}
	
	public LabelSignalMessage createEndMessage(long time) {
		return new LabelSignalMessage(time, LabelSignalMessage.Type.END, this);
	}
	
	@Override
	public String toString() {
		return "{label:"+label_+",id:"+id_+"}";
	}
	
	//
	public String getLabel() {
		return label_;
	}
	
	@Override
	public int compareTo(LabelInfo rhs) {
		{
			int d=this.label_.compareTo(rhs.label_);
			if (d!=0) return d;
		}
		{
			int d=this.id_ - rhs.id_;
			return d;
		}
	}

	public int getId() {
		return id_;
	}

	/** auto generated */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + id_;
		result = prime * result + ((label_ == null) ? 0 : label_.hashCode());
		return result;
	}

	/** auto generated */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		LabelInfo other = (LabelInfo) obj;
		if (id_ != other.id_)
			return false;
		if (label_ == null) {
			if (other.label_ != null)
				return false;
		} else if (!label_.equals(other.label_))
			return false;
		return true;
	}
}
