package jp.hasc.hasctool.core.messaging;

import jp.hasc.hasctool.core.data.SignalMessage;

/**
 * SignalMessageが時刻順に出力されていない時に、警告メッセージを出します
 * @author iwasaki
 */
public class SignalMessageTimeChecker {
	/** logger for this class */
	private final static org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory
			.getLog(SignalMessageTimeChecker.class);
	
	private long previousSignalTime_=Long.MIN_VALUE;
	
	public void checkMessage(Object message) {
		if (message instanceof SignalMessage) {
			SignalMessage lm = (SignalMessage)message;
			long curTime=lm.getTime();
			if (curTime<previousSignalTime_) {
				LOG.warn("The signal's time:"+curTime+" is less than the previous message's time: "+previousSignalTime_);
			}
			previousSignalTime_=curTime;
		}
	}
}
