package jp.hasc.hasctool.core.runtime.filter.file.path;

import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * ファイル名を入力順にカウントしながら自動生成します
 * @author hiro
 */
public class CSVFileNameCreator extends AbstractFilter{

	private String feature_;
	private int count_;
	private String fname_ = "";
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			String[] part = s.split("/");
			String[] row = part[part.length-1].split("-");
			String extension = row[row.length-1];
			String fname = "";
			String fpath = "";
			for(int i=0; i<part.length-1; i++){
				fname += part[i];
				fpath += part[i];
				if(i != part.length-2)fpath += "/";
			}
			for(int i=0; i<row.length-1; i++){
				fname += row[i];
			}
			if(!(fname_ .equals(fname)))count_++;
			fname_ = fname;
			outputMessage(fpath+"/"+feature_+count_+"-"+extension);
		}else{
			//BEGIN,END message
			outputMessage(message);
		}
	}

	public void setFeature(String feature){
		feature_ = feature;
	}
	
	public void setStart(int count){
		count_ = count;
	}
	

}
