package jp.hasc.hasctool.core.runtime.filter.file.table;

import jp.hasc.hasctool.core.runtime.RuntimeContext;


/**
 * 出力:ファイルに関する情報を出力します
 * @author hiro
 */

public class FileNameFilter extends AbstractElementFilter{

	String element_ = "FilePath,FileName,Person,Activity";

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		super.element_ = this.element_;
	}

	String getFeature(String filePath){
		String[] fileInfo = filePath.split("\\.");
		String row = fileInfo[0];
		String[] element = filePath.split("/");
		int len = element.length;
		for(int i = len; i>len-3; i--){
			row += "," + element[i-1];
		}
		return row;
	}

}
