package jp.hasc.hasctool.core.runtime.hierarchize;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 入力（inputPort）：任意のオブジェクト系列、または文字列系列
 * 出力（outputPort）：XbdExecutionRequest系列
 * 
 * 入力されたオブジェクトごとに、以下の要求を表したXbdExecutionRequestを出力します。
 * - propertyNameプロパティを指定した場合、指定されたプロパティへ、入力されたオブジェクトを代入します。
 * - asXbdFilePathプロパティをtrueにした場合、xbdファイルのパスとして、入力された文字列を扱います。
 * - srcStringInXbdプロパティを指定した場合、xbdファイル内で、指定した文字列を、入力された文字列に置換します。
 * 
 * @author iwasaki
 */
public class XERequestCreationFilter extends AbstractFilter {
	private String propertyName_=null;
	private boolean asXbdFilePath_=false;
	private String srcStringInXbd_=null;

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message==EnumCommand.BEGIN || message==EnumCommand.END) {
			outputMessage(message);
		}else{
			XbdExecutionRequest req=new XbdExecutionRequest();
			if (propertyName_!=null) req.setProperty(propertyName_, message);
			if (asXbdFilePath_) req.setXbdFilePath((String)message);
			if (srcStringInXbd_!=null) req.setReplacingInXbd(srcStringInXbd_, (String)message);
			outputMessage(req);
		}
	}
	
	/**
	 * 入力を代入する先のプロパティを指定します。
	 * 形式：blockName.propertyPath
	 */
	public void setPropertyName(String propertyName) {
		propertyName_ = propertyName;
	}

	/**
	 * 入力を、Xbdファイルのパスとして扱うかを指定します。
	 */
	public void setAsXbdFilePath(boolean asXbdFilePath) {
		asXbdFilePath_ = asXbdFilePath;
	}

	/**
	 * Xbdファイル内での置換元の文字列を指定します。
	 */
	public void setSrcStringInXbd(String replacingSrcInXml) {
		srcStringInXbd_ = replacingSrcInXml;
	}
}
