package jp.hasc.hasctool.core.runtime.hierarchize;

import java.util.HashMap;
import java.util.Map;

import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * xbdファイルの実行要求です。
 * @author iwasaki
 */
public class XbdExecutionRequest {
	@XStreamAlias("xbdFilePath")
	private String xbdFilePath_ = null;
	
	@XStreamAlias("properties")
	private HashMap<String, Object> properties_ = new HashMap<String, Object>();
	
	@XStreamAlias("replacingsInXbd")
	private HashMap<String, String> replacingsInXbd_ = new HashMap<String, String>();

	public String getXbdFilePath() {
		return xbdFilePath_;
	}
	
	/**
	 * 実行するxbdファイルのパスを指定します。
	 */
	public void setXbdFilePath(String xbdFilePath) {
		xbdFilePath_ = xbdFilePath;
	}
	
	/**
	 * ブロック図内の、指定されたプロパティを変更します。
	 */
	public void setProperty(String blockName, String propertyName, Object propertyValue) {
		String key=blockName+"."+propertyName;
		setProperty(key,propertyValue);
	}
	
	/**
	 * ブロック図内の、指定されたプロパティを変更します。
	 * @param blockAndPropertyName 形式：blockName.propertyName
	 */
	public void setProperty(String blockAndPropertyName, Object propertyValue) {
		if (propertyValue!=null) {
			properties_.put(blockAndPropertyName, propertyValue);
		}else{
			properties_.remove(blockAndPropertyName);
		}
	}
	
	/**
	 * xbdファイル内の、指定された文字列を置換します。
	 */
	public void setReplacingInXbd(String srcString, String destString) {
		if (destString!=null) {
			replacingsInXbd_.put(srcString, destString);
		}else{
			replacingsInXbd_.remove(srcString);
		}
	}
	
	/**
	 * 他のXbdExecutionRequestを、自分自身へマージします。
	 * 既に存在する要素は、上書きされます。
	 */
	public void merge(XbdExecutionRequest rhs) {
		xbdFilePath_=rhs.xbdFilePath_;
		properties_.putAll(rhs.properties_);
		replacingsInXbd_.putAll(rhs.replacingsInXbd_);
	}

	public Map<String, Object> getProperties() {
		return properties_;
	}

	public Map<String, String> getReplacingsInXbd() {
		return replacingsInXbd_;
	}

	@Override
	public String toString() {
		return "XbdExecutionRequest [xbdFilePath=" + xbdFilePath_
				+ ", properties=" + properties_ + ", replacingsInXbd="
				+ replacingsInXbd_ + "]";
	}
}
