package jp.hasc.hasctool.core.runtime.sink;

import jp.hasc.hasctool.core.data.EnumCommand;


/**
 * 文字列系列を、commons loggingのLOGに出力します
 * @author iwasaki
 */
public class LogSink extends AbstractSink {
	/** logger for this class */
	private final static org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory
			.getLog(LogSink.class);
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			LOG.info((String)message);
		}else if (message==EnumCommand.BEGIN || message==EnumCommand.END) {
			// NOP
		}else{
			LOG.debug("unknown: "+message.toString());
		}
	}
}
